/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.xpmenu;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;


/**
 * Sample class that demonstrates the usage of <code>JAnimatePanel</code>.
 */
public class JXPMenuItem extends JLabel {
    private String text;

    public JXPMenuItem(String text, Icon icon) {
        super(icon, SwingConstants.LEFT);
        super.setForeground(Color.blue);
        this.text = text;
        super.setText("<html>" + JXPMenuItem.this.text + "</html>");

        addMouseListener(new MouseAdapter() {
            public void mouseEntered(MouseEvent e) {
                setText("<html><u>" + JXPMenuItem.this.text + "</u></html>");
            }

            public void mouseExited(MouseEvent e) {
                setText("<html>" + JXPMenuItem.this.text + "</html>");
            }

            public void mousePressed(MouseEvent e) {
                System.out.println("Item " + JXPMenuItem.this.text + " clicked");
            }
        });
    }
}
