/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.outlookpanel.renderers.metalwood;

import com.smardec.asc.outlookpanel.OutlookTabHeaderRenderer;
import com.smardec.asc.outlookpanel.JOutlookTabHeader;

import javax.swing.*;
import java.awt.*;
import java.io.Serializable;

/**
 * Sample class that demonstrates the usage of <code>JOutlookPanel</code>.
 */
public class MetalWoodOutlookTabHeaderRenderer extends JButton implements OutlookTabHeaderRenderer, Serializable {
    private static final ImageIcon imageIconOn = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOn.gif"));
    private static final ImageIcon imageIconOut = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOut.gif"));
    private static final ImageIcon imageIconArrowUp = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/ArrowUp.gif"));
    private static final ImageIcon imageIconArrowDown = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/ArrowDown.gif"));

    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    private boolean mouseOver;
    private boolean mousePressed;

    /**
     * Creates a default tab renderer.
     */
    public MetalWoodOutlookTabHeaderRenderer() {
        setOpaque(true);
    }

    public Component getOutlookTabHeaderRendererComponent(JOutlookTabHeader jOutlookTabHeader, boolean mouseOver, boolean mousePressed) {
        this.mouseOver = mouseOver;
        this.mousePressed = mousePressed;

        setFont(jOutlookTabHeader.getFont());
        setText(jOutlookTabHeader.getText());
        setSize(jOutlookTabHeader.getSize());

        try {
            int s_index = jOutlookTabHeader.getOutlookTab().getOutlookPanel().getSelectedTabIndex();
            int index = jOutlookTabHeader.getOutlookTab().getOutlookPanel().getTabIndex(jOutlookTabHeader.getOutlookTab());
            if (index != -1 && s_index != -1) {
                if (index <= s_index)
                    setIcon(imageIconArrowDown);
                else
                    setIcon(imageIconArrowUp);
            }

        } catch (Exception e) {}

        return this;
    }

    public void paint(Graphics g) {
        if (mouseOver)
            g.drawImage(imageIconOn.getImage(), 0, 0, getWidth(), getHeight(), this);
        else
            g.drawImage(imageIconOut.getImage(), 0, 0, getWidth(), getHeight(), this);

        g.setFont(getFont());

        viewRect.x = 0;
        viewRect.y = 0;
        viewRect.width = getWidth() - (viewRect.x);
        viewRect.height = getHeight() - (viewRect.y);

        textRect.x = textRect.y = textRect.width = textRect.height = 0;
        iconRect.x = iconRect.y = iconRect.width = iconRect.height = 0;

        String text = SwingUtilities.layoutCompoundLabel(this,
                g.getFontMetrics(),
                getText(), getIcon(),
                getVerticalAlignment(), getHorizontalAlignment(),
                getVerticalTextPosition(), getHorizontalTextPosition(),
                viewRect, iconRect, textRect,
                getText() == null ? 0 : 4); // getIconTextGap() works only on jdk 1.4, 4 - default value
                // TODO: use reflection to use getIconTextGap() on jdk 1.4


        if (getIcon() != null) {
            getIcon().paintIcon(this, g, iconRect.x, iconRect.y);
        }

        paintText(g, this, textRect, text);

    }
    
    protected void paintText(Graphics g, JButton jButton, Rectangle textRect, String text) {
        AbstractButton b = jButton;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        // TODO: use reflection to use getDisplayedMnemonicIndex on jdk 1.4, getMnemonic on jdk 1.3
//        for jdk 1.4 b.getDisplayedMnemonicIndex
//        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        
//        for jdk 1.3 b.getMnemonic();
        int mnemonicIndex = -1;

        /* Draw the Text */
        if (model.isEnabled()) {
            /*** paint the text normally */
            g.setColor(b.getForeground());
            drawStringUnderlineCharAt(g, text, mnemonicIndex,
                    textRect.x,
                    textRect.y + fm.getAscent());
        } else {
            /*** paint the text disabled ***/
            g.setColor(b.getBackground().brighter());
            drawStringUnderlineCharAt(g, text, mnemonicIndex,
                    textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            drawStringUnderlineCharAt(g, text, mnemonicIndex,
                    textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        g.drawString(text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

}

