/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.rotate.JVerticalButton;
import com.smardec.asc.rotate.RotateConstants;
import com.smardec.asc.rotate.JVerticalToggleButton;
import com.smardec.asc.rotate.JVerticalLabel;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;
 
public class VerticalDemo extends DemoableAdapter {
    public final static String CONSTRAINT_VERTICAL_COMPONENTS = "VerticalComponents";
    public final static String CAPTION_VERTICAL_COMPONENTS = "Vertical components";
    public final static String INTRO_VERTICAL_COMPONENTS = "<html><p align=left color=black>JVerticalButton, JVerticalLabel and JVerticalToggleButton - swing components with ninety degrees clockwise or contraclockwise rotation support</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;


    public String getID() {
        return CONSTRAINT_VERTICAL_COMPONENTS;
    }

    public String getCaption() {
        return CAPTION_VERTICAL_COMPONENTS;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NEW;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_VERTICAL_COMPONENTS);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);

        JPanel jPanelVerticalButtons = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder("JVerticalButton");
        titledBorder.setTitleColor(Color.black);
        jPanelVerticalButtons.setBorder(titledBorder);

        JVerticalButton jVerticalButtonLeft = new JVerticalButton("Left rotation", RotateConstants.ROTATE_LEFT);
        JVerticalButton jVerticalButtonRight = new JVerticalButton("Right rotation", RotateConstants.ROTATE_RIGHT);

        jVerticalButtonLeft.setPreferredSize(new Dimension(25, 110));
        jVerticalButtonRight.setPreferredSize(new Dimension(25, 110));

        Util.constrain(jPanelVerticalButtons, jVerticalButtonLeft,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalButtons, jVerticalButtonRight,
                1, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalButtons, Box.createGlue(),
                2, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                5, 5, 5, 5);

        JPanel jPanelVerticalToogleButtons = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder("JVerticalToggleButton");
        titledBorder.setTitleColor(Color.black);
        jPanelVerticalToogleButtons.setBorder(titledBorder);

        JVerticalToggleButton jVerticalToggleButtonLeft = new JVerticalToggleButton("Left rotation", RotateConstants.ROTATE_LEFT);
        JVerticalToggleButton jVerticalToggleButtonRight = new JVerticalToggleButton("Right rotation", RotateConstants.ROTATE_RIGHT);

        jVerticalToggleButtonLeft.setPreferredSize(new Dimension(25, 110));
        jVerticalToggleButtonRight.setPreferredSize(new Dimension(25, 110));

        Util.constrain(jPanelVerticalToogleButtons, jVerticalToggleButtonLeft,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalToogleButtons, jVerticalToggleButtonRight,
                1, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalToogleButtons, Box.createGlue(),
                2, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                5, 5, 5, 5);

        JPanel jPanelVerticalLabels = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder("JVerticalLabel");
        titledBorder.setTitleColor(Color.black);
        jPanelVerticalLabels.setBorder(titledBorder);

        JVerticalLabel jVerticalLabelLeft = new JVerticalLabel("Left rotation", RotateConstants.ROTATE_LEFT);
        JVerticalLabel jVerticalLabelRight = new JVerticalLabel("Right rotation", RotateConstants.ROTATE_RIGHT);

        jVerticalLabelLeft.setPreferredSize(new Dimension(25, 110));
        jVerticalLabelRight.setPreferredSize(new Dimension(25, 110));

        jVerticalLabelLeft.setHorizontalAlignment(SwingConstants.CENTER);
        jVerticalLabelRight.setHorizontalAlignment(SwingConstants.CENTER);

        Util.constrain(jPanelVerticalLabels, jVerticalLabelLeft,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalLabels, jVerticalLabelRight,
                1, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                5, 5, 5, 5);
        Util.constrain(jPanelVerticalLabels, Box.createGlue(),
                2, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                5, 5, 5, 5);

        JPanel jPanelTmp = new JPanel(new GridBagLayout());
        Util.constrain(jPanelTmp, jPanelVerticalButtons,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelTmp, jPanelVerticalToogleButtons,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelTmp, jPanelVerticalLabels,
                0, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelTmp, Box.createGlue(),
                0, 4, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 0, 0, 0);

        Util.constrain(jPanelContents, new JScrollPane(jPanelTmp),
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 0, 0, 0);
        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_VERTICAL_COMPONENTS),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
