/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.xmlbars.toolbar.layouts.ToolbarDockLayout;
import com.smardec.asc.xmlbars.toolbar.layouts.ToolBarDockConstraints;
import com.smardec.asc.xmlbars.toolbar.JAscToolBar;
import com.smardec.asc.xmlbars.MenuToolBarManager;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ToolBarMenuBarDemo extends DemoableAdapter {
    private final ImageIcon imageIcon16 = new ImageIcon(ToolBarMenuBarDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/icon16.gif"));
    public final static String CONSTRAINT_TOOLBAR = "Toolbar & Menubar";
    public final static String CAPTION_TOOLBAR = "Toolbar & Menubar";
    public final static String INTRO_TOOLBAR = "<html><p align=left color=black>JAscToolBar - Swing component based on JToolBar that provides advanced layouting. Controls that cannot be placed on the toolbar due to lack of available space are put into dropdown menu.<br><br>" +
            "MenuToolBarManager - builds menus and toolbars using the information from the xml. It also supports enabling/disabling actions or group of actions, getting menus, toolbars and actions by id.<br><br>" +
            "JIconicCheckBoxMenuItem - menu item that can be selected or unselected. It is similar to default JCheckBoxMenuItem, but uses graphic icons instead of checkmark to indicate selected/unselected state.<br><br>" +
            "JIconicCheckBoxMenuItem, JAscCheckBoxMenuItem and JAscRadioButtonMenuItem override default parent menu behaviour after mouse click. It can be useful if you need to change several checkbox menu items at one time. They also keep selected state synchronized with the action.<br><br>" +
            "JToolBarButton and JToolBarToggleButton represent button and toggle button for toolbar respectively. Theirs selected state is synchronized with the action.<br><br>" +
            "ToolbarDockLayout - LayoutManager that provides layout management with different styles for dockable toolbars." +
            "</p></html>";
    public final static String INTRO_TOOLBAR2 = "<html><p align=left color=black>Click 'Open demo frame' to open the demo frame. Layout of the toolbars in the demo frame depends on the settings in the Options panel. You can select 'Multiline', 'Wrapping multiline' or 'Single line' depending on your application's needs. To change the size of the icons use the 'Use small buttons for toolbar'."  +
            "</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private ToolbarDemoFrame toolbarDemoFrame;

    private JRadioButton jRadioButtonStyleMulti;
    private JRadioButton jRadioButtonStyleWrapMulti;
    private JRadioButton jRadioButtonStyleSingle;
    private JCheckBox jCheckBoxSmallButton;

    public String getID() {
        return CONSTRAINT_TOOLBAR;
    }

    public String getCaption() {
        return CAPTION_TOOLBAR;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TOOLBAR);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);
        JEditorPane jEditorPane = new JEditorPane("text/html", INTRO_TOOLBAR);
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        jEditorPane.setBackground(jPanelContents.getBackground());

        Util.constrain(jPanelContents, new JScrollPane(jEditorPane),
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 5, 0, 0);

        JButton jButtonToolbarFrame = new JButton("Open demo frame");
        jButtonToolbarFrame.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (toolbarDemoFrame != null) {
                    toolbarDemoFrame.hide();
                    toolbarDemoFrame.dispose();
                }
                int style = ToolbarDockLayout.DOCK_STYLE_MULTILINE;
                if (jRadioButtonStyleMulti.isSelected())
                    style = ToolbarDockLayout.DOCK_STYLE_MULTILINE;
                else if (jRadioButtonStyleWrapMulti.isSelected())
                    style = ToolbarDockLayout.DOCK_STYLE_WRAPPING_MULTILINE;
                else if (jRadioButtonStyleSingle.isSelected())
                    style = ToolbarDockLayout.DOCK_STYLE_SINGLE_LINE;

                toolbarDemoFrame = new ToolbarDemoFrame(jCheckBoxSmallButton.isSelected(), style);
                toolbarDemoFrame.pack();
                toolbarDemoFrame.setSize(440, 350);
                Util.centerOnScreen(toolbarDemoFrame);
                toolbarDemoFrame.updateToolBar();
                toolbarDemoFrame.show();
            }
        });

        JPanel jPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel.add(jButtonToolbarFrame);

        Util.constrain(jPanelContents, jPanel,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        JPanel jPanelStyle = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select toolbar layout dock style:");
        titledBorder.setTitleColor(Color.black);
        jPanelStyle.setBorder(titledBorder);

        jRadioButtonStyleMulti = new JRadioButton("Multiline");
        jRadioButtonStyleWrapMulti = new JRadioButton("Wrapping multiline");
        jRadioButtonStyleSingle = new JRadioButton("Single line");

        ButtonGroup group = new ButtonGroup();
        group.add(jRadioButtonStyleMulti);
        group.add(jRadioButtonStyleWrapMulti);
        group.add(jRadioButtonStyleSingle);

        jRadioButtonStyleMulti.doClick();

        jCheckBoxSmallButton = new JCheckBox("Use small buttons for toolbar");

        Util.constrain(jPanelStyle, jRadioButtonStyleMulti,
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelStyle, jRadioButtonStyleWrapMulti,
                1, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelStyle, jRadioButtonStyleSingle,
                1, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);


        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jPanelStyle,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 3, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxSmallButton,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_TOOLBAR2),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    private class ToolbarDemoFrame extends JFrame {
        private JAscToolBar jAscToolBarMain;
        private JAscToolBar jAscToolBarZoom;
        private JAscToolBar jAscToolBarMedia;
        private JAscToolBar jAscToolBarMedia2;
        private JAscToolBar jAscToolBarMedia3;
        private String intro = "This demo demonstates:\n" +
                "JMenu and JMenuItem with text, icons, shortcuts, etc.\n" +
                "\tsee examples in menu File or Edit\n" +
                "JIconicCheckBoxMenuItem - JCheckBoxMenuItem that uses graphic icons instead of checkmark to indicate selected/unselected state\n" +
                "\tsee examples in View->Toolbar or View->Statusbar\n" +
                "Dynamic menu - menu that is built from specified class name\n" +
                "\tsee example in View->Look&Feel\n" +
                "JAscRadioButtonMenuItem - JRadioButtonMenuItem that overrides default behaviour after mouse click\n" +
                "\tsee example in Text->Align left, Text->Align right, etc.\n" +
                "JAscCheckBoxMenuItem - JCheckBoxMenuItem that overrides default behaviour after mouse click\n" +
                "\tsee examples in Text->Style bold, Text->Style italic, etc.\n" +
                "JAscToolBar - JToolBar with advanced layout and extended controls: JToolbarButton and  JToggleToolbarButton\n" +
                "\n\n" +
                "All menus and toolbars are built using the information from the xml of the following structure:\n\n";
        private String dtd = intro +
                "<!--\n" +
                "    The menutoolbar element is the root element of the menutoolbar.xml file. It contains all the information used by\n" +
                "    com.smardec.asc.xmlbars.MenuToolBarManager to build menus and toolbars.\n" +
                "    -->\n" +
                "<!ELEMENT menutoolbar (actions, menubars, popups, toolbars)>\n" +
                "\n" +
                "<!--\n" +
                "    The actions element contains information about the actions.\n" +
                "    -->\n" +
                "<!ELEMENT actions (action+)>\n" +
                "<!--\n" +
                "    'icon-base-path' action's base path, used with 'icon' and 'large-icon' to complete icon's path in action element.\n" +
                "    -->\n" +
                "<!ATTLIST actions icon-base-path  CDATA   #IMPLIED >\n" +
                "\n" +
                "<!--\n" +
                "    The action element describes action that is used for menu items and toolbar buttons.\n" +
                "    -->\n" +
                "<!ELEMENT action EMPTY>\n" +
                "<!--\n" +
                "    'id'            unique action id\n" +
                "    'class'         action's class derived from com.smardec.asc.xmlbars.BasicAction that represents the action\n" +
                "    'text'          action's text, used for menu items and toolbar buttons,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'mnemonic'      action's mnemonic, used for menu items,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'keystroke'     action's keystroke, used for menu items,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'icon',         action's icon used for menu items and toolbar buttons,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'large-icon'    action's large icon, used for toolbar buttons,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'tooltip',      action's tooltip, used for menu items and toolbar buttons,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'enabled',      action's status, used to enable/disable action,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    'group-id',     action's group id, used to manage group of actions,\n" +
                "                    overrides the corresponding attribute of the action\n" +
                "    -->\n" +
                "<!ATTLIST action\n" +
                "    id          CDATA   #REQUIRED\n" +
                "    class       CDATA   #REQUIRED\n" +
                "    text        CDATA   #IMPLIED\n" +
                "    mnemonic    CDATA   #IMPLIED\n" +
                "    keystroke   CDATA   #IMPLIED\n" +
                "    icon        CDATA   #IMPLIED\n" +
                "    large-icon  CDATA   #IMPLIED\n" +
                "    tooltip     CDATA   #IMPLIED\n" +
                "    enabled     CDATA   #IMPLIED\n" +
                "    group-id    CDATA   #IMPLIED\n" +
                ">\n" +
                "\n" +
                "<!--\n" +
                "    The menubars element contains information about the menubars.\n" +
                "    -->\n" +
                "<!ELEMENT menubars (menubar)>\n" +
                "<!--\n" +
                "    The menubar element contains information about the menubar.\n" +
                "    -->\n" +
                "<!ELEMENT menubar (items)>\n" +
                "<!--\n" +
                "    'id'    unique menubar id\n" +
                "    -->\n" +
                "<!ATTLIST menubar id CDATA #REQUIRED>\n" +
                "\n" +
                "<!--\n" +
                "    The popups element contains information about the popup menus.\n" +
                "    -->\n" +
                "<!ELEMENT popups (popupmenu)>\n" +
                "<!--\n" +
                "    The popupmenu element contains information about the popup menu.\n" +
                "    -->\n" +
                "<!ELEMENT popupmenu (items)>\n" +
                "<!--\n" +
                "    'id'    unique popup menu id\n" +
                "    -->\n" +
                "<!ATTLIST popupmenu id CDATA #REQUIRED >\n" +
                "\n" +
                "<!--\n" +
                "    The toolbars element contains information about the toolbars.\n" +
                "    -->\n" +
                "<!ELEMENT toolbars (toolbar)>\n" +
                "<!--\n" +
                "    The toolbar element contains information about the toolbar.\n" +
                "    -->\n" +
                "<!ELEMENT toolbar (items)>\n" +
                "<!--\n" +
                "    'id'            unique toolbar id\n" +
                "    'orientation'   specifies toolbar's orientation\n" +
                "    'floatable'     specifies toolbar's floatable property\n" +
                "    'button-size'   specifies toolbar's button size in pixels\n" +
                "    -->\n" +
                "<!ATTLIST toolbar\n" +
                "    id              CDATA                       #REQUIRED\n" +
                "    name            CDATA                       #REQUIRED\n" +
                "    orientation     (horizontal | vertical)     #IMPLIED\n" +
                "    floatable       (yes | true | no | false)   #IMPLIED\n" +
                "    button-size     CDATA                       #IMPLIED\n" +
                ">\n" +
                "\n" +
                "<!--\n" +
                "    The items element contains information about the menu toolbar items.\n" +
                "    -->\n" +
                "<!ELEMENT items (menu | item | separator)+>\n" +
                "\n" +
                "<!--\n" +
                "    The menu element contains information about the menu.\n" +
                "    -->\n" +
                "<!ELEMENT menu (items?)>\n" +
                "<!--\n" +
                "    'id'        unique menu id\n" +
                "    'text'      specifies menu's text\n" +
                "    'mnemonic'  specifies menu's keyboard mnemonic\n" +
                "    'class'     class derived from javax.swing.JMenu that represents the menu with its items and submenus,\n" +
                "                used to create dynamic menus like look&feel menu\n" +
                "    -->\n" +
                "<!ATTLIST menu\n" +
                "    id          CDATA   #REQUIRED\n" +
                "    text        CDATA   #IMPLIED\n" +
                "    mnemonic    CDATA   #IMPLIED\n" +
                "    class       CDATA   #IMPLIED\n" +
                ">\n" +
                "\n" +
                "<!--\n" +
                "    The item element contains information about the menu or toolbar item.\n" +
                "    -->\n" +
                "<!ELEMENT item EMPTY>\n" +
                "<!--\n" +
                "    'action-id'     specifies action for the item\n" +
                "    'type'          type of menu or toolbar item, 'AscCheckBox' 'AscRadioButton' 'IconicCheckBox'\n" +
                "                    can be used for menu items, 'ToggleButton' can be used for toolbar items\n" +
                "    'button-group'  specifies multiple-exclusion scope for radio button menu items or toggle toolbar buttons\n" +
                "    -->\n" +
                "<!ATTLIST item\n" +
                "    action-id       CDATA                                                           #REQUIRED\n" +
                "    type            (AscCheckBox | AscRadioButton | IconicCheckBox | ToggleButton)  #IMPLIED\n" +
                "    button-group    CDATA                                                           #IMPLIED\n" +
                ">\n" +
                "\n" +
                "<!--\n" +
                "    The separator element specifies separator for menu and toolbar items.\n" +
                "    -->\n" +
                "<!ELEMENT separator EMPTY>";

        public ToolbarDemoFrame(boolean useSmallIconButtons, int style) {
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            setTitle("Toolbar Demo");
            if (imageIcon16 != null)
                setIconImage(imageIcon16.getImage());


            ToolbarDockLayout mgr = new ToolbarDockLayout(this, style);
            getContentPane().setLayout(mgr);
            try {
                MenuToolBarManager menuToolBarManager = new MenuToolBarManager(getClass().getClassLoader().getResourceAsStream("com/smardec/demo/asc/menutoolbar.xml"));
                menuToolBarManager.setUseSmallToolBarIcons(useSmallIconButtons);
                menuToolBarManager.buildMenuAndToolbar();

                JMenuBar jMenuBarXml = menuToolBarManager.getMenuBarById("MenuBar.Main");
                if (jMenuBarXml != null)
                    setJMenuBar(jMenuBarXml);

                JAscToolBar jAscToolBarMain = menuToolBarManager.getToolBarById("ToolBar.Main");
                if (jAscToolBarMain != null) {
                    this.jAscToolBarMain = jAscToolBarMain;
                    getContentPane().add(jAscToolBarMain, ToolbarDockLayout.North);
                }
                JAscToolBar jAscToolBarZoom = menuToolBarManager.getToolBarById("ToolBar.Zoom");
                if (jAscToolBarZoom != null) {
                    this.jAscToolBarZoom = jAscToolBarZoom;
                    getContentPane().add(jAscToolBarZoom, new ToolBarDockConstraints(ToolBarDockConstraints.WEST, 0, 0));
                }
                JAscToolBar jAscToolBarMedia = menuToolBarManager.getToolBarById("ToolBar.Media");
                if (jAscToolBarMedia != null) {
                    this.jAscToolBarMedia = jAscToolBarMedia;
                    getContentPane().add(jAscToolBarMedia, new ToolBarDockConstraints(ToolBarDockConstraints.WEST, 1, 0));
                }
                JAscToolBar jAscToolBarMedia2 = menuToolBarManager.getToolBarById("ToolBar.Media2");
                if (jAscToolBarMedia2 != null) {
                    this.jAscToolBarMedia2 = jAscToolBarMedia2;
                    getContentPane().add(jAscToolBarMedia2, new ToolBarDockConstraints(ToolBarDockConstraints.EAST, 0, 0));
                }
                JAscToolBar jAscToolBarMedia3 = menuToolBarManager.getToolBarById("ToolBar.Media3");
                if (jAscToolBarMedia3 != null) {
                    this.jAscToolBarMedia3 = jAscToolBarMedia3;
                    getContentPane().add(jAscToolBarMedia3, new ToolBarDockConstraints(ToolBarDockConstraints.EAST, 1, 0));
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            JTextArea jTextArea = new JTextArea(dtd);
            jTextArea.setEditable(false);
            jTextArea.setCaretPosition(0);
            getContentPane().add(new JScrollPane(jTextArea), ToolbarDockLayout.Center);

        }

        private void updateToolBar() {
            if (jAscToolBarMain != null)
                jAscToolBarMain.updateUI();
            if (jAscToolBarZoom != null)
                jAscToolBarZoom.updateUI();
            if (jAscToolBarMedia != null)
                jAscToolBarMedia.updateUI();
        }
    }
}
