/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.table.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class SortedFilteredTableDemo extends DemoableAdapter {
    public final static String CONSTRAINT_TABLE = "Table";
    public final static String CAPTION_TABLE = "Sorted and filtered table";
    public final static String INTRO_TABLE = "<html><p align=left color=black>SortedTableModel - TableModel with sorting and multisorting support. FilteredTableModel - TableModel with filtering support. SortedTableModel and FilteredTableModel can be combined to create sorted and filtered table.</p><p align=left color=black>To enable multisorting support just hold CTRL key and click on several table headers. The column header will show an icon than represents column sort order (ascending/descending) and column sort rank.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private FilteredTableModel filteredTableModel;

    public String getID() {
        return CONSTRAINT_TABLE;
    }

    public String getCaption() {
        return CAPTION_TABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        class ComparableBoolean implements Comparable {
            Boolean bool;

            public ComparableBoolean(boolean value) {
                bool = new Boolean(value);
            }

            public ComparableBoolean(String s) {
                bool = new Boolean(s);
            }

            public int compareTo(Object o) {
                return -bool.toString().compareTo(o.toString());
            }

            public String toString() {
                return bool.toString();
            }
        }

        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);

        // Create default model
        final int n = 26;
        Object objects[][] = new Object[n][4];
        char c = 'A';
        long time = System.currentTimeMillis();
        for (int i = 0; i < n; i++) {
            objects[i][0] = new Character(c++);
            objects[i][1] = new Date(time - 1000 * 60 * 60 * 24 * (i - 10));
            int temp = (i + 1) * (i % 2 == 0 ? -1 : 1) / 2;
            if (temp > 0) temp = 14 - temp;
            objects[i][2] = new Integer(temp);
            objects[i][3] = new ComparableBoolean(i % 2 == 0);
        }

        final DefaultTableModel defaultTableModel = new DefaultTableModel(objects, new Object[]{"String", "Date", "Number", "Boolean"}) {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        SortedTableModel sortedTableModel = new SortedTableModel(defaultTableModel);

        filteredTableModel = new FilteredTableModel(sortedTableModel);
        final JTable jTable = new JTable(filteredTableModel);
        jTable.getTableHeader().setReorderingAllowed(true);
        jTable.getTableHeader().addMouseListener(new SortedTableHeaderMouseListener(jTable, sortedTableModel));
        jTable.getTableHeader().setDefaultRenderer(new SortedTableHeaderRenderer(jTable, sortedTableModel));


        Util.constrain(jPanelTreeTable, new JScrollPane(jTable),
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        final RowFilter rowFilter = new RowFilter() {
            public boolean exclude(int row, TableModel tableModel) {
                if (((Number) tableModel.getValueAt(row, 2)).intValue() < 0)
                    return true;
                else
                    return false;
            }
        };
        final JCheckBox jCheckBoxEnableFilter = new JCheckBox("Filter rows with negative values");
        jCheckBoxEnableFilter.setSelected(false);
        jCheckBoxEnableFilter.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (jCheckBoxEnableFilter.isSelected())
                    filteredTableModel.setRowFilter(rowFilter);
                else
                    filteredTableModel.setRowFilter(null);

//                Integer [] test = new Integer[n];
//                Arrays.fill(test, new Integer(666));
//                defaultTableModel.addColumn("Test", test);
//                defaultTableModel.addRow(new Object[]{new Character('Z'), new Date(1999, 10, 10), new Integer(666)});

//                jTable.getColumnModel().addColumn(new TableColumn(1));
//                System.out.println("jTable.getColumnCount() = " + jTable.getColumnCount());
//                System.out.println("jTable.getModel().getColumnCount() = " + jTable.getModel().getColumnCount());
//                for (int i = 0; i < jTable.getModel().getColumnCount(); i++) {
//                    System.out.println("jTable.getModel().getColumnName(i) = " + jTable.getModel().getColumnName(i));
//                }
            }
        });

        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jCheckBoxEnableFilter,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_TABLE),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
