/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.quick.JQuickList;
import com.smardec.asc.quick.JQuickTable;
import com.smardec.asc.quick.JQuickTextArea;
import com.smardec.asc.quick.JQuickTree;
import com.smardec.asc.tree.WideTreeCellEditor;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class QuickSearchDemo extends DemoableAdapter {
    public final static String CONSTRAINT_QUICK_SEARCH = "QuickSearch";
    public final static String CAPTION_QUICK_SEARCH = "Quick search";
    public final static String INTRO_QUICK_SEARCH = "<html><p align=left color=black>JQuickTree, JQuickTable, JQuickList and JQuickTextArea are Swing components with quick search capabilities. Start typing when the component has focus to use the quick search or select 'Invoke search on keystroke' and invoke quick search on keystroke. To use search mask ('*' and '?') select 'Search on mask'. While quick search is active you can select next/previuos matched element using up/down arrow keys, Ctrl+A selects all matching elements. JQuickTree also demostrates the usage of WideTreeCellEditor - an editor that has tree object's width.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JTabbedPane jTabbedPaneQuickSearch;
    private ChangeListener changeListener;
    private JQuickTree jQuickTree;
    private JQuickList jQuickList;
    private JQuickTable jQuickTable;
    private JQuickTextArea jQuickTextArea;

    public String getID() {
        return CONSTRAINT_QUICK_SEARCH;
    }

    public String getCaption() {
        return CAPTION_QUICK_SEARCH;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        changeListener = new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                try {
                    JScrollPane jScrollPane = (JScrollPane) jTabbedPaneQuickSearch.getComponentAt(jTabbedPaneQuickSearch.getModel().getSelectedIndex());
                    jScrollPane.getViewport().getView().requestFocus();
                } catch (Exception exception) {
                    try {
                        JScrollPane jScrollPane = (JScrollPane) ((Container) jTabbedPaneQuickSearch.getComponentAt(jTabbedPaneQuickSearch.getModel().getSelectedIndex())).getComponent(0);
                        jScrollPane.getViewport().getView().requestFocus();
                    } catch (Exception exception2) {}
                }
            }
        };

        jQuickTree = new JQuickTree();
        jQuickTree.setEditable(true);
        jQuickTree.setCellEditor(new WideTreeCellEditor(jQuickTree));
        for (int i = 0; i < jQuickTree.getRowCount(); i++)
            jQuickTree.expandRow(i);

        jQuickList = new JQuickList(new String[]{"blue", "violet", "red", "yellow",
                "basketball", "soccer", "football", "hockey",
                "hot dogs", "pizza", "ravioli", "bananas"});

        jQuickTable = new JQuickTable(new String[][]{
                {"blue", "ravioli", "pizza"},
                {"violet", "bananas", "ravioli"},
                {"red", "pizza", "bananas"},
                {"yellow", "hot dogs", "football"},
                {"basketball", "hockey", "soccer"},
                {"soccer", "football", "hot dogs"},
                {"football", "soccer", "hockey"},
                {"hockey", "basketball", "yellow"},
                {"hot dogs", "yellow", "basketball"},
                {"pizza", "red", "blue"},
                {"ravioli", "blue", "violet"},
                {"bananas", "violet", "red"},
        }, new String[]{"Column 1", "Column 2", "Column 3"});
        JPanel jPanelQuickTable = new JPanel(new BorderLayout());
        jPanelQuickTable.add(new JScrollPane(jQuickTable), BorderLayout.CENTER);
        final JCheckBox jCheckBoxSearchEntireTable = new JCheckBox("Search in selected column only");
        jCheckBoxSearchEntireTable.setSelected(!jQuickTable.isSearchEntireTable());
        jCheckBoxSearchEntireTable.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jQuickTable.setSearchEntireTable(!jCheckBoxSearchEntireTable.isSelected());
                changeListener.stateChanged(null);
            }
        });
        jPanelQuickTable.add(jCheckBoxSearchEntireTable, BorderLayout.SOUTH);

        jQuickTextArea = new JQuickTextArea("blue\n" + "violet\n" + "red\n" + "yellow\n" +
                "basketball\n" + "soccer\n" + "football\n" + "hockey\n" +
                "hot dogs\n" + "pizza\n" + "ravioli\n" + "bananas\n");

        jTabbedPaneQuickSearch = new JTabbedPane(JTabbedPane.TOP);
        jTabbedPaneQuickSearch.addFocusListener(new FocusAdapter() {
            public void focusGained(FocusEvent e) {
                changeListener.stateChanged(null);
            }
        });
        jTabbedPaneQuickSearch.addChangeListener(changeListener);
        jTabbedPaneQuickSearch.addTab("JQuickTree", new JScrollPane(jQuickTree));
        jTabbedPaneQuickSearch.addTab("JQuickList", new JScrollPane(jQuickList));
        jTabbedPaneQuickSearch.addTab("JQuickTable", jPanelQuickTable);
        jTabbedPaneQuickSearch.addTab("JQuickTextArea", new JScrollPane(jQuickTextArea));

        JPanel jPanelQuickSearch = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_QUICK_SEARCH);
        titledBorder.setTitleColor(Color.black);
        jPanelQuickSearch.setBorder(titledBorder);
        Util.constrain(jPanelQuickSearch, jTabbedPaneQuickSearch,
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 0, 5);
        return jPanelQuickSearch;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        final JCheckBox jCheckBoxStrict = new JCheckBox("Strict mode");
        jCheckBoxStrict.setToolTipText("Strict mode");
        jCheckBoxStrict.setSelected(jQuickTree.getQuickSearch().isStrict());
        jCheckBoxStrict.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jQuickTree.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                jQuickList.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                jQuickTable.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                jQuickTextArea.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxPrefereSelection = new JCheckBox("Prefere selection");
        jCheckBoxPrefereSelection.setToolTipText("Prefere selection");
        jCheckBoxPrefereSelection.setSelected(jQuickTree.getQuickSearch().isPrefereSelection());
        jCheckBoxPrefereSelection.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jQuickTree.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                jQuickList.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                jQuickTable.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                jQuickTextArea.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxSearchOnlyOnKeystroke = new JCheckBox("Invoke search on keystroke (Ctrl+F)");
        jCheckBoxSearchOnlyOnKeystroke.setToolTipText("Invoke search on keystroke (Ctrl+F)");
        jCheckBoxSearchOnlyOnKeystroke.setSelected(jQuickTree.getQuickSearch().getKeyStroke() != null);
        jCheckBoxSearchOnlyOnKeystroke.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                KeyStroke keyStroke = jCheckBoxSearchOnlyOnKeystroke.isSelected() ? KeyStroke.getKeyStroke("ctrl F") : null;
                jQuickTree.getQuickSearch().setKeyStroke(keyStroke);
                jQuickList.getQuickSearch().setKeyStroke(keyStroke);
                jQuickTable.getQuickSearch().setKeyStroke(keyStroke);
                jQuickTextArea.getQuickSearch().setKeyStroke(keyStroke);
                changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxUseMask = new JCheckBox("Search on mask ('*' and '?' can be used, not applicable to JQuickTextArea)");
        jCheckBoxUseMask.setToolTipText("Search on mask ('*' and '?' can be used, not applicable to JQuickTextArea)");
        jCheckBoxUseMask.setSelected(jQuickTree.getQuickSearch().isMaskSearch());
        jCheckBoxUseMask.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jQuickTree.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                jQuickList.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                jQuickTable.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                jQuickTextArea.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                changeListener.stateChanged(null);
            }
        });

        jPanelOptions = new JPanel(new GridBagLayout());

        Util.constrain(jPanelOptions, jCheckBoxStrict,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxPrefereSelection,
                0, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 1, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxSearchOnlyOnKeystroke,
                0, 4, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 1, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxUseMask,
                0, 5, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 1, 0, 5);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_QUICK_SEARCH),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    public void demoBecomeVisible() {
        jTabbedPaneQuickSearch.requestFocus();
    }
}
