/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.gradient.QuickGradientPaint;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class QuickGradientDemo extends DemoableAdapter {
    public final static String CONSTRAINT_GRADIENT = "Gradient";
    public final static String CAPTION_GRADIENT = "QuickGradientPaint";
    public final static String INTRO_GRADIENT = "<html><p align=left color=black>QuickGradientPaint - optimized Paint for gradients. Useful for creating modern and fast user interfaces.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    public String getID() {
        return CONSTRAINT_GRADIENT;
    }

    public String getCaption() {
        return CAPTION_GRADIENT;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelGradient = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_GRADIENT);
        titledBorder.setTitleColor(Color.black);
        jPanelGradient.setBorder(titledBorder);

        final JLabel jLabelControl = new JLabel();
        final JLabel jLabelTimeForSmart = new JLabel("Time of 100 runs: <unknown>");
        jLabelTimeForSmart.setForeground(Color.black);
        final JLabel jLabelTimeForStandard = new JLabel("Time of 100 runs: <unknown>");
        jLabelTimeForStandard.setForeground(Color.black);

        final JPanel jPanelSmartGradient = new JPanel() {
            protected void paintComponent(Graphics g) {
                ((Graphics2D) g).setPaint(new QuickGradientPaint(Color.gray, Color.lightGray, false));
                if ("smart".equals(jLabelControl.getText())) {
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 100; i++)
                        ((Graphics2D) g).fill(new Rectangle(getSize()));
                    long time = System.currentTimeMillis() - start;
                    jLabelTimeForSmart.setText("Time of 100 runs: " + time + " milliseconds");
                    jLabelControl.setText("");
                } else
                    ((Graphics2D) g).fill(new Rectangle(getSize()));
            }
        };
        jPanelSmartGradient.setBorder(BorderFactory.createLineBorder(Color.black));

        final JPanel jPanelStandardGradient = new JPanel() {
            protected void paintComponent(Graphics g) {
                ((Graphics2D) g).setPaint(new GradientPaint(0, 0, Color.gray, getWidth(), getHeight(), Color.lightGray));
                if ("standard".equals(jLabelControl.getText())) {
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 100; i++)
                        ((Graphics2D) g).fill(new Rectangle(getSize()));
                    long time = System.currentTimeMillis() - start;
                    jLabelTimeForStandard.setText("Time of 100 runs: " + time + " milliseconds");
                    jLabelControl.setText("");
                } else
                    ((Graphics2D) g).fill(new Rectangle(getSize()));
            }
        };
        jPanelStandardGradient.setBorder(BorderFactory.createLineBorder(Color.black));

        JButton jButtonMeasureSmart = new JButton("Measure");
        jButtonMeasureSmart.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jLabelControl.setText("smart");
                jPanelSmartGradient.repaint();
            }
        });
        JButton jButtonMeasureStandard = new JButton("Measure");
        jButtonMeasureStandard.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jLabelControl.setText("standard");
                jPanelStandardGradient.repaint();
            }
        });

        JLabel jLabel1 = new JLabel("Quick gradient:");
        jLabel1.setForeground(Color.black);
        Util.constrain(jPanelGradient, jLabel1,
                0, 1, 2, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 5, 0, 5);
        Util.constrain(jPanelGradient, jPanelSmartGradient,
                0, 2, 2, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 5, 0, 5);
        Util.constrain(jPanelGradient, jLabelTimeForSmart,
                0, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                10, 5, 0, 0);
        Util.constrain(jPanelGradient, jButtonMeasureSmart,
                1, 3, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHEAST, 1.0, 0.0,
                5, 0, 0, 5);
        JLabel jLabel2 = new JLabel("Standard gradient:");
        jLabel2.setForeground(Color.black);
        Util.constrain(jPanelGradient, jLabel2,
                0, 4, 2, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 5, 0, 5);
        Util.constrain(jPanelGradient, jPanelStandardGradient,
                0, 5, 2, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 5, 0, 5);
        Util.constrain(jPanelGradient, jLabelTimeForStandard,
                0, 6, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                10, 5, 0, 0);
        Util.constrain(jPanelGradient, jButtonMeasureStandard,
                1, 6, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHEAST, 1.0, 0.0,
                5, 0, 5, 5);
        return jPanelGradient;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        return null;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_GRADIENT),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
