/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.asc.animatepanel.JAnimatePanel;
import com.smardec.demo.asc.Demoable;
import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.xpmenu.JXPMenuItem;
import com.smardec.demo.asc.xpmenu.JXPMenuTab;
import com.smardec.demo.asc.xpmenu.renderers.XPPanelRenderer;
import com.smardec.demo.asc.xpmenu.renderers.XPTabHeaderRenderer;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class JXPMenuDemo implements Demoable {
    public final static String CONSTRAINT_XP_MENU = "XPMenu";
    public final static String CAPTION_XP_MENU = "JXPMenu";
    public final static String INTRO_XP_MENU = "<html><p align=left color=black>JXPMenu - open source component which demonstrates the usage of JAnimatePanel.</p></html>";


    public String getID() {
        return CONSTRAINT_XP_MENU;
    }

    public String getCaption() {
        return CAPTION_XP_MENU;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_XP_MENU);
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);

        final JAnimatePanel jAnimatePanel = new JAnimatePanel();
        jAnimatePanel.setDelay(5);//
        jAnimatePanel.setStep(10);
        jAnimatePanel.setTabSpacing(10);
        jAnimatePanel.setTabHeight(29);
        jAnimatePanel.setIndentLeft(10);
        jAnimatePanel.setIndentRight(10);
        jAnimatePanel.setIndentTop(10);
        jAnimatePanel.setIndentBottom(10);
        jAnimatePanel.setAnimateTabHeaderRenderer(new XPTabHeaderRenderer());
        jAnimatePanel.setAnimatePanelRenderer(new XPPanelRenderer());
        jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
//        jAnimatePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JXPMenuTab jAnimateTab;

        jAnimateTab = new JXPMenuTab("Programms", null);
        jAnimatePanel.addTab(jAnimateTab);
        jAnimateTab.addMenuItem(new JXPMenuItem("Notepad", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcNote.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Internet Explorer", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcIE.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Microsoft Word", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcWord.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Microsoft PowerPoint", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcPp.gif"))));


        jAnimateTab = new JXPMenuTab("Programms", null);
        jAnimatePanel.addTab(jAnimateTab);
        jAnimateTab.addMenuItem(new JXPMenuItem("Notepad", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcNote.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Internet Explorer", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcIE.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Microsoft Word", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcWord.gif"))));
        jAnimateTab.addMenuItem(new JXPMenuItem("Microsoft PowerPoint", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/asc/img/XPRenderer/icons/IcPp.gif"))));


        jAnimatePanel.setPreferredSize(new Dimension(200, jAnimatePanel.getPreferredSize().height));

        JPanel jPanelTmpAnimate = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jAnimatePanel, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jPanelTmpAnimate.add(jScrollPane, BorderLayout.CENTER);


        final JCheckBox jCheckBoxAnimateMode = new JCheckBox("Animated tab movement");
        jCheckBoxAnimateMode.setSelected(jAnimatePanel.getDefaultPaintMode() == JAnimatePanel.MODE_ANIMATE);

        jCheckBoxAnimateMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (jCheckBoxAnimateMode.isSelected())
                    jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
                else
                    jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_DEFAULT);
            }
        });

        Util.constrain(jPanel, new JLabel(INTRO_XP_MENU),
                0, 0, 2, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 5.0, 0.0,
                0, 5, 5, 5);

        Util.constrain(jPanel, jCheckBoxAnimateMode,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);

        Util.constrain(jPanel, jPanelTmpAnimate,
                1, 1, 1, 4, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 5.0, 1.0,
                5, 5, 5, 5);

        return jPanel;
    }

    public JPanel getOptionPanel() {
        return null;
    }

    public JPanel getDescriptionPanel() {
        return null;
    }

    public void init(Component parentFrame) {}

    public void deinit() {}

    public void demoWillBecomeVisible() {}

    public void demoWillBecomeInVisible() {}

    public void demoBecomeVisible() {}

    public void demoBecomeInVisible() {}

    public void applicationWillBeClose() {}
}
