/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.treetable.DefaultTreeTableModel;
import com.smardec.asc.treetable.JTreeTable;
import com.smardec.asc.treetable.TreeTableNode;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class JTreeTableDemo extends DemoableAdapter {
    public final static String CONSTRAINT_TREETABLE = "TreeTable";
    public final static String CAPTION_TREETABLE = "JTreeTable";
    public final static String INTRO_TREETABLE = "<html><p align=left color=black>JTreeTable - Swing component that combines JTable and JTree. It extends JTable and uses a JTree to display the cells in a particular column of the table.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JTreeTable jTreeTable;

    public String getID() {
        return CONSTRAINT_TREETABLE;
    }

    public String getCaption() {
        return CAPTION_TREETABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TREETABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);

        // Create default model
        TreeTableNode root = new TreeTableNode(new Object[]{"Sample JTreeTable", "", ""});
        TreeTableNode level1Node = null, level2Node = null;
        for (int i = 1; i <= 150; i++) {
            TreeTableNode node = new TreeTableNode(new Object[]{"Name " + i, "Value " + i, "Description " + i});
            if (i % 7 == 1) {
                root.add(node);
                level1Node = node;
            } else if (i % 7 == 2 || i % 7 == 5) {
                level1Node.add(node);
                level2Node = node;
            } else
                level2Node.add(node);
        }

        jTreeTable = new JTreeTable(new DefaultTreeTableModel(root));
        jTreeTable.getTree().setRootVisible(true);

        Util.constrain(jPanelTreeTable, new JScrollPane(jTreeTable),
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        final JCheckBox jCheckBoxWideSelectionBackground = new JCheckBox("Use wide selection background");
        jCheckBoxWideSelectionBackground.setSelected(jTreeTable.isWideSelectionBackground());
        jCheckBoxWideSelectionBackground.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jTreeTable.setWideSelectionBackground(jCheckBoxWideSelectionBackground.isSelected());
                jTreeTable.repaint();
            }
        });

        final JCheckBox jCheckBoxRootVisible = new JCheckBox("Is root visible");
        jCheckBoxRootVisible.setSelected(jTreeTable.getTree().isRootVisible());
        jCheckBoxRootVisible.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jTreeTable.getTree().setRootVisible(jCheckBoxRootVisible.isSelected());
                ((AbstractTableModel) jTreeTable.getModel()).fireTableDataChanged();
                jTreeTable.repaint();
            }
        });


        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jCheckBoxWideSelectionBackground,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxRootVisible,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 1, 0, 5);
        Util.constrain(jPanelOptions, Box.createGlue(),
                0, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_TREETABLE),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);


        return jPanelDesc;
    }
}
