/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.asc.spantable.DefaultSpanTableModel;
import com.smardec.asc.spantable.JSpanTable;
import com.smardec.asc.table.renderers.DefaultImageCellRenderer;
import com.smardec.asc.table.renderers.DefaultTextCellRenderer;
import com.smardec.asc.table.wrappers.DefaultImageWrapper;
import com.smardec.asc.table.wrappers.DefaultTextWrapper;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.spantable.HtmlRenderer;
import com.smardec.demo.asc.spantable.HtmlTextWrapper;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.util.Arrays;
import java.util.Vector;

public class JSpanTableDemo extends DemoableAdapter {
    public final static String CONSTRAINT_TREETABLE = "SpanTable";
    public final static String CAPTION_TREETABLE = "JSpanTable";
    public final static String INTRO_TREETABLE = "<html><p align=left color=black>JSpanTable - Swing component based on JTable that provides api to create table with cell span</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JSpanTable jSpanTable;

    private static final ImageIcon imageIconF430 = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_430.jpg"));
    private static final ImageIcon imageIconF612 = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_612.jpg"));
    private static final ImageIcon imageIconFEnzo = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_enzo.jpg"));

    public String getID() {
        return CONSTRAINT_TREETABLE;
    }

    public String getCaption() {
        return CAPTION_TREETABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NEW;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TREETABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);

        jSpanTable = initCarDemo();
        setHeaderHeight(jSpanTable);
        Util.constrain(jPanelTreeTable, new JScrollPane(jSpanTable),
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;
        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_TREETABLE),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    private JSpanTable initCarDemo() {
        Vector columnNames = new Vector();
        columnNames.add("img");
        columnNames.add("txt");
        columnNames.add("txt");
        JSpanTable jSpanTable = new JSpanTable(new DefaultSpanTableModel(getCarInfo(), false, columnNames));
        jSpanTable.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        JTableHeader tableHeader = jSpanTable.getTableHeader();
        Dimension dim = tableHeader.getPreferredSize();
        dim.height = 0;
        tableHeader.setMinimumSize(dim);
        tableHeader.setMaximumSize(dim);
        tableHeader.setPreferredSize(dim);
        tableHeader.setSize(dim);
        tableHeader.setVisible(false);
        TableColumn column = jSpanTable.getColumnModel().getColumn(0);
        column.setResizable(false);
        int w = 196;
        column.setPreferredWidth(w);
        column.setMaxWidth(w);
        column.setMinWidth(w);
        column = jSpanTable.getColumnModel().getColumn(1);
        column.setResizable(false);
        w = 100;
        column.setPreferredWidth(w);
        column.setMaxWidth(w);
        column.setMinWidth(w);

        createSpans(jSpanTable);
        jSpanTable.setDefaultCellRenderer(DefaultTextWrapper.class, new DefaultTextCellRenderer());
        jSpanTable.setDefaultCellRenderer(DefaultImageWrapper.class, new DefaultImageCellRenderer());
        jSpanTable.setDefaultCellRenderer(HtmlTextWrapper.class, new HtmlRenderer());

        return jSpanTable;
    }

    private Vector getCarInfo() {
        Vector v = new Vector();
        Object[] data;
        Font font = UIManager.getFont("Table.font");
        data = new Object[]{
                new Object[]{new DefaultTextWrapper("Ferrari F430", Color.red, new Color(0, 100, 0), font.deriveFont(Font.BOLD, font.getSize() + 2), SwingUtilities.CENTER, SwingConstants.CENTER), null, null},
                new Object[]{new DefaultImageWrapper(imageIconF430, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(Font.BOLD)), "2005 - present"},
                new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(Font.BOLD)), "Sports car"},
                new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(Font.BOLD)), "2-seat Berlinetta; 2-seat Spider"},
                new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(Font.BOLD)), "4.3 L V8"},
                new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(Font.BOLD)), "360.4 kW (483 hp) at 8500 rpm"},
                new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(Font.BOLD)), "465 Nm (343 ftlbf) at 5250 rpm"},
                new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(Font.BOLD)), "3.5 second"},
                new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(Font.BOLD)), "$170,045"},
                new Object[]{new HtmlTextWrapper("The Ferrari F430 is a sports car automobile, the replacement for the Ferrari 360." +
                        " It debuted at the September, 2004 Paris Motor Show. European left-hand drive sales began in November, 2004," +
                        " but right-hand drive sales did not start until Spring 2005, and the United States did not get the F430 " +
                        "until the Summer of 2005."), null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null}};
        for (int i = 0; i < data.length; i++) {
            v.add(Arrays.asList((Object[]) data[i]));
        }
        data = new Object[]{
                new Object[]{new DefaultTextWrapper("Ferrari 612 Scaglietti", Color.red, new Color(0, 100, 0), font.deriveFont(Font.BOLD, font.getSize() + 2), SwingUtilities.CENTER, SwingConstants.CENTER), null, null},
                new Object[]{new DefaultImageWrapper(imageIconF612, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(Font.BOLD)), "2004 - present"},
                new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(Font.BOLD)), "Gran Turismo"},
                new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(Font.BOLD)), "front-engined 2+2 coupe"},
                new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(Font.BOLD)), "5.7 L Tipo F133E V12"},
                new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(Font.BOLD)), "397 kW (533 hp) at 7250 rpm"},
                new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(Font.BOLD)), "588 Nm (434 ftlbf) at 5250 rpm"},
                new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(Font.BOLD)), "4.2 seconds"},
                new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(Font.BOLD)), "$247,850"},
                new Object[]{new HtmlTextWrapper("The Ferrari 612 Scaglietti is a Gran Turismo car produced by Ferrari since 2004. " +
                        "It is a large two door coupe with a 2+2 seating arrangement. " +
                        "The 612 Scaglietti was designed to replace the smaller Ferrari 456M."), null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null}};
        for (int i = 0; i < data.length; i++) {
            v.add(Arrays.asList((Object[]) data[i]));
        }
        data = new Object[]{
                new Object[]{new DefaultTextWrapper("Ferrari 'Enzo Ferrari'", Color.red, new Color(0, 100, 0), font.deriveFont(Font.BOLD, font.getSize() + 2), SwingUtilities.CENTER, SwingConstants.CENTER), null, null},
                new Object[]{new DefaultImageWrapper(imageIconFEnzo, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(Font.BOLD)), "2003 - 2004"},
                new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(Font.BOLD)), "Supercar"},
                new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(Font.BOLD)), "coupe"},
                new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(Font.BOLD)), "6.0 L V12"},
                new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(Font.BOLD)), "660 PS (651 hp/485 kW) at 7800 rpm"},
                new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(Font.BOLD)), "657 Nm (485 ftlbf) at 5500 rpm"},
                new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(Font.BOLD)), "3.3 seconds"},
                new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(Font.BOLD)), "$643,330"},
                new Object[]{new HtmlTextWrapper("The Enzo Ferrari is a 12-cylinder Ferrari supercar named after the company's founder, Enzo Ferrari. " +
                        "It was built in 2003 using Formula One technology, such as a carbon-fiber body, F1-style sequential shift transmission, " +
                        "and carbon-ceramic brake discs. Also used are technologies not allowed in F1 such as active aerodynamics."), null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null},
                new Object[]{null, null, null}};
        for (int i = 0; i < data.length; i++) {
            v.add(Arrays.asList((Object[]) data[i]));
        }
        return v;
    }

    private void createSpans(JSpanTable jSpanTable) {
        int captionRowIndex = 0;
        int imageRowIndex = 1;
        int descRowIndex = 9;
        int carRowCount = 14;
        for (int i = 0; i < jSpanTable.getRowCount(); i++)
            for (int j = 0; j < jSpanTable.getColumnCount(); j++) {
                if ((i - captionRowIndex) % carRowCount == 0 && j == 0) {
                    jSpanTable.createSpan(i, j, 1, 3);
                } else if ((i - imageRowIndex) % carRowCount == 0 && j == 0)
                    jSpanTable.createSpan(i, j, 8, 1);
                else if ((i - descRowIndex) % carRowCount == 0 && j == 0)
                    jSpanTable.createSpan(i, j, 5, 3);
            }
    }

    private void setHeaderHeight(JSpanTable jSpanTable) {
        int carRowCount = 14;
        for (int i = 0; i < jSpanTable.getRowCount(); i += carRowCount)
            jSpanTable.setRowHeight(i, jSpanTable.getRowHeight(i) + 4);
    }
}
