/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.rotate.JVerticalButton;
import com.smardec.asc.rotate.RotateConstants;
import com.smardec.asc.sliderpanel.JSliderPanel;
import com.smardec.asc.sliderpanel.JSliderPanelContainer;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class JSliderPanelDemo extends DemoableAdapter {
    public final static String CONSTRAINT_SLIDER = "Slider";
    public final static String CAPTION_SLIDER = "JSliderPanel";
    public final static String INTRO_SLIDER = "<html><p align=left color=black>JSliderPanel - component that allows to create sliding panels with various settings." +
            "<br>Use 'top', 'left', 'bottom', 'right' control buttons to show/hide corresponding slider panels. " +
            "<br>To animate show/hide movement use 'Animated movement' check box. " +
            "<br>'Hide when focus lost' option allows to hide slider panel when it loses focus. " +
            "<br>'Show docked' option makes the slider to show initialy docked." +
            "<br>You can use slider menu to pin, dock and hide slider panel.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JSliderPanelContainer jSliderPanelContainer;

    public String getID() {
        return CONSTRAINT_SLIDER;
    }

    public String getCaption() {
        return CAPTION_SLIDER;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelSlider = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_SLIDER);
        titledBorder.setTitleColor(Color.black);
        jPanelSlider.setBorder(titledBorder);

        jSliderPanelContainer = new JSliderPanelContainer();
        jSliderPanelContainer.addBaseComponent(new JScrollPane(new JTree()));

        Util.constrain(jPanelSlider, jSliderPanelContainer,
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        return jPanelSlider;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        final JCheckBox jCheckBoxAnimate = new JCheckBox("Animated movement");
        final JCheckBox jCheckBoxFocus = new JCheckBox("Hide when focus lost");
        final JCheckBox jCheckBoxDock = new JCheckBox("Show docked");
        jPanelOptions = new JPanel(new GridBagLayout());


        jCheckBoxAnimate.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelLeft = jSliderPanelContainer.getLeftSlider();
                JSliderPanel jSliderPanelRight = jSliderPanelContainer.getRightSlider();
                JSliderPanel jSliderPanelTop = jSliderPanelContainer.getTopSlider();
                JSliderPanel jSliderPanelBottom = jSliderPanelContainer.getBottomSlider();
                if (jCheckBoxAnimate.isSelected()) {
                    jSliderPanelLeft.setDefaultShowMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelLeft.setDefaultHideMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelRight.setDefaultShowMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelRight.setDefaultHideMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelTop.setDefaultShowMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelTop.setDefaultHideMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelBottom.setDefaultShowMode(JSliderPanel.MODE_ANIMATE);
                    jSliderPanelBottom.setDefaultHideMode(JSliderPanel.MODE_ANIMATE);
                } else {
                    jSliderPanelLeft.setDefaultShowMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelLeft.setDefaultHideMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelRight.setDefaultShowMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelRight.setDefaultHideMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelTop.setDefaultShowMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelTop.setDefaultHideMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelBottom.setDefaultShowMode(JSliderPanel.MODE_DEFAULT);
                    jSliderPanelBottom.setDefaultHideMode(JSliderPanel.MODE_DEFAULT);
                }
            }
        });
        jCheckBoxAnimate.doClick();
        jCheckBoxFocus.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelLeft = jSliderPanelContainer.getLeftSlider();
                JSliderPanel jSliderPanelRight = jSliderPanelContainer.getRightSlider();
                JSliderPanel jSliderPanelTop = jSliderPanelContainer.getTopSlider();
                JSliderPanel jSliderPanelBottom = jSliderPanelContainer.getBottomSlider();

                jSliderPanelLeft.setPin(!jCheckBoxFocus.isSelected());
                jSliderPanelRight.setPin(!jCheckBoxFocus.isSelected());
                jSliderPanelTop.setPin(!jCheckBoxFocus.isSelected());
                jSliderPanelBottom.setPin(!jCheckBoxFocus.isSelected());
            }
        });
        jCheckBoxDock.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jCheckBoxAnimate.setEnabled(!jCheckBoxDock.isSelected());
            }
        });

        Util.constrain(jPanelOptions, jCheckBoxAnimate,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 2, 0, 0);
        Util.constrain(jPanelOptions, jCheckBoxFocus,
                0, 1, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 2, 0, 0);
        Util.constrain(jPanelOptions, jCheckBoxDock,
                0, 2, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 2, 0, 0);


        final JPanel jPanelLeft = new JPanel(new BorderLayout());
        jPanelLeft.add(new JScrollPane(new JTree()));

        final JPanel jPanelRight = new JPanel(new BorderLayout());
        jPanelRight.add(new JScrollPane(new JTree()));

        final JPanel jPanelTop = new JPanel(new BorderLayout());
        jPanelTop.add(new JScrollPane(new JTree()));

        final JPanel jPanelBottom = new JPanel(new BorderLayout());
        jPanelBottom.add(new JScrollPane(new JTree()));

        final JButton jButtonRight = new JVerticalButton("right", RotateConstants.ROTATE_RIGHT);
        jButtonRight.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelRight = jSliderPanelContainer.getRightSlider();
                if (!jSliderPanelRight.isVisible()) {
                    try {
                        jSliderPanelRight.setSliderCaption("Right caption");
                        jSliderPanelRight.setDock(jCheckBoxDock.isSelected());
                        jSliderPanelRight.setPin(!jCheckBoxFocus.isSelected());

                        if (jCheckBoxAnimate.isSelected())
                            jSliderPanelContainer.showPanelRight(jPanelRight, JSliderPanel.MODE_ANIMATE);
                        else
                            jSliderPanelContainer.showPanelRight(jPanelRight, JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelRight.isSliderHiding())
                            if (jCheckBoxAnimate.isSelected())
                                jSliderPanelContainer.hidePanelRight(JSliderPanel.MODE_ANIMATE);
                            else
                                jSliderPanelContainer.hidePanelRight(JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });

        JButton jButtonLeft = new JVerticalButton("left", RotateConstants.ROTATE_LEFT) {
            public Dimension getPreferredSize() {
                return jButtonRight.getPreferredSize();
            }
        };
        jButtonLeft.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelLeft = jSliderPanelContainer.getLeftSlider();
                if (!jSliderPanelLeft.isVisible()) {
                    try {
                        jSliderPanelLeft.setSliderCaption("Left caption");

                        jSliderPanelLeft.setDock(jCheckBoxDock.isSelected());
                        jSliderPanelLeft.setPin(!jCheckBoxFocus.isSelected());

                        if (jCheckBoxAnimate.isSelected())
                            jSliderPanelContainer.showPanelLeft(jPanelLeft, JSliderPanel.MODE_ANIMATE);
                        else
                            jSliderPanelContainer.showPanelLeft(jPanelLeft, JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelLeft.isSliderHiding())
                            if (jCheckBoxAnimate.isSelected())
                                jSliderPanelContainer.hidePanelLeft(JSliderPanel.MODE_ANIMATE);
                            else
                                jSliderPanelContainer.hidePanelLeft(JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });

        final JButton jButtonBottom = new JButton("bottom");
        jButtonBottom.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelBottom = jSliderPanelContainer.getBottomSlider();

                if (!jSliderPanelBottom.isVisible()) {
                    try {
                        jSliderPanelBottom.setSliderCaption("Bottom caption");
                        jSliderPanelBottom.setDock(jCheckBoxDock.isSelected());
                        jSliderPanelBottom.setPin(!jCheckBoxFocus.isSelected());

                        if (jCheckBoxAnimate.isSelected())
                            jSliderPanelContainer.showPanelBottom(jPanelBottom, JSliderPanel.MODE_ANIMATE);
                        else
                            jSliderPanelContainer.showPanelBottom(jPanelBottom, JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelBottom.isSliderHiding())
                            if (jCheckBoxAnimate.isSelected())
                                jSliderPanelContainer.hidePanelBottom(JSliderPanel.MODE_ANIMATE);
                            else
                                jSliderPanelContainer.hidePanelBottom(JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });

        JButton jButtonTop = new JButton("top") {
            public Dimension getPreferredSize() {
                return jButtonBottom.getPreferredSize();
            }
        };
        jButtonTop.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelTop = jSliderPanelContainer.getTopSlider();
                if (!jSliderPanelTop.isVisible()) {
                    try {
                        jSliderPanelTop.setSliderCaption("Top caption");
                        jSliderPanelTop.setDock(jCheckBoxDock.isSelected());
                        jSliderPanelTop.setPin(!jCheckBoxFocus.isSelected());

                        if (jCheckBoxAnimate.isSelected())
                            jSliderPanelContainer.showPanelTop(jPanelTop, JSliderPanel.MODE_ANIMATE);
                        else
                            jSliderPanelContainer.showPanelTop(jPanelTop, JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelTop.isSliderHiding())
                            if (jCheckBoxAnimate.isSelected())
                                jSliderPanelContainer.hidePanelTop(JSliderPanel.MODE_ANIMATE);
                            else
                                jSliderPanelContainer.hidePanelTop(JSliderPanel.MODE_DEFAULT);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });

        JPanel jPanelControl = new JPanel(new GridBagLayout());

        Util.constrain(jPanelControl, jButtonLeft,
                0, 0, 1, 2, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 5, 5, 5);
        Util.constrain(jPanelControl, jButtonTop,
                1, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 0, 5, 0);
        Util.constrain(jPanelControl, jButtonBottom,
                1, 1, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelControl, jButtonRight,
                2, 0, 1, 2, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 5, 5, 5);


        Util.constrain(jPanelOptions, jPanelControl,
                0, 3, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 0, 0, 0);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_SLIDER),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    public void demoBecomeVisible() {
        jSliderPanelContainer.setVisible(true);
    }

    public void demoBecomeInVisible() {
        jSliderPanelContainer.setVisible(false);
    }
}
