/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.outlookpanel.JOutlookButton;
import com.smardec.asc.outlookpanel.JOutlookPanel;
import com.smardec.asc.outlookpanel.JOutlookTab;
import com.smardec.asc.outlookpanel.renderers.DefaultOutlookButtonRenderer;
import com.smardec.asc.outlookpanel.renderers.DefaultOutlookScrollButtonRenderer;
import com.smardec.demo.asc.outlookpanel.renderers.blueplastic.BluePlasticOutlookTabBodyRenderer;
import com.smardec.demo.asc.outlookpanel.renderers.blueplastic.BluePlasticOutlookTabHeaderRenderer;
import com.smardec.demo.asc.outlookpanel.renderers.metalwood.MetalWoodOutlookTabBodyRenderer;
import com.smardec.demo.asc.outlookpanel.renderers.metalwood.MetalWoodOutlookTabHeaderRenderer;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class JOutlookPanelDemo extends DemoableAdapter {
    public final static String CONSTRAINT_OUTLOOK = "Outlook";
    public final static String CAPTION_OUTLOOK = "JOutlookPanel";
    public final static String INTRO_OUTLOOK = "<html><p align=left color=black>JOutlookPanel - Microsoft Outlook-style component with custom renderers support. " +
            "<br>You can choose one of the custom renderers in the 'Options panel'. If 'No renderer' button is selected - specified project look&feel is used to render JOutlookPanel. To animate tab movement select 'Animate tab movement' checkbox.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private static final ImageIcon imageIconScrollUp = new ImageIcon(JOutlookPanelDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/ScrollUp.gif"));
    private static final ImageIcon imageIconScrollUpS = new ImageIcon(JOutlookPanelDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/ScrollUpS.gif"));

    private static final ImageIcon imageIconScrollDown = new ImageIcon(JOutlookPanelDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/ScrollDown.gif"));
    private static final ImageIcon imageIconScrollDownS = new ImageIcon(JOutlookPanelDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/ScrollDownS.gif"));

    private JOutlookPanel jOutlookPanel;
    private OutlookCaption outlookCaption;
    private JPanel jPanelOutlookContainer;

    public String getID() {
        return CONSTRAINT_OUTLOOK;
    }

    public String getCaption() {
        return CAPTION_OUTLOOK;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelOutlook = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_OUTLOOK);
        titledBorder.setTitleColor(Color.black);
        jPanelOutlook.setBorder(titledBorder);

        jOutlookPanel = new JOutlookPanel();
        JOutlookTab jOutlookTab;
        jOutlookTab = new JOutlookTab("Tab 1", null);
        jOutlookTab.addButton(new JOutlookButton("First button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Second button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Third button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Fourth button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookPanel.addTab(jOutlookTab);

        jOutlookTab = new JOutlookTab("Tab 2", null);
        jOutlookTab.addButton(new JOutlookButton("First button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Second button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookPanel.addTab(jOutlookTab);

        jOutlookTab = new JOutlookTab("Tab 3", null);
        jOutlookTab.addButton(new JOutlookButton("First button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Second button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Third button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookTab.addButton(new JOutlookButton("Fourth button", new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/Mouse3d.gif"))));
        jOutlookPanel.addTab(jOutlookTab);

        jOutlookPanel.setPreferredSize(new Dimension(200, jOutlookPanel.getPreferredSize().height));


        outlookCaption = new OutlookCaption();

        outlookCaption.setPreferredSize(new Dimension(76, 76));

        jPanelOutlookContainer = new JPanel(new BorderLayout());
        jPanelOutlookContainer.add(outlookCaption, BorderLayout.NORTH);
        jPanelOutlookContainer.add(jOutlookPanel, BorderLayout.CENTER);


        jOutlookPanel.setPreferredSize(new Dimension(250, 100));
        Util.constrain(jPanelOutlook, jPanelOutlookContainer,
                0, 1, 1, 1, GridBagConstraints.VERTICAL, GridBagConstraints.NORTHWEST, 0.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelOutlook, Box.createGlue(),
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);

        return jPanelOutlook;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        JPanel jPanelRenderer = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select renderer:");
        titledBorder.setTitleColor(Color.black);
        jPanelRenderer.setBorder(titledBorder);
        JRadioButton jRadioButtonRenderer1 = new JRadioButton("No renderer");
        JRadioButton jRadioButtonRenderer2 = new JRadioButton("Renderer 1 ");
        JRadioButton jRadioButtonRenderer3 = new JRadioButton("Renderer 2 ");

        ButtonGroup group = new ButtonGroup();
        group.add(jRadioButtonRenderer1);
        group.add(jRadioButtonRenderer2);
        group.add(jRadioButtonRenderer3);

        jRadioButtonRenderer1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jOutlookPanel.setOutlookTabHeaderRenderer(null);
                jOutlookPanel.setOutlookTabBodyRenderer(null);
                jOutlookPanel.setOutlookButtonRenderer(new DefaultOutlookButtonRenderer());
                jOutlookPanel.setTabSpacing(0);
                jOutlookPanel.setOutlookScrollButtonUpRenderer(null);
                jOutlookPanel.setOutlookScrollButtonDownRenderer(null);
                outlookCaption.lf_type = outlookCaption.LF_NATIVE;
                jOutlookPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                jPanelOutlookContainer.repaint();
            }
        });
        jRadioButtonRenderer2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jOutlookPanel.setOutlookTabHeaderRenderer(new MetalWoodOutlookTabHeaderRenderer());
                jOutlookPanel.setOutlookTabBodyRenderer(new MetalWoodOutlookTabBodyRenderer());
                jOutlookPanel.setOutlookButtonRenderer(new DefaultOutlookButtonRenderer());
                jOutlookPanel.setTabSpacing(1);
                jOutlookPanel.setOutlookScrollButtonUpRenderer(null);
                jOutlookPanel.setOutlookScrollButtonDownRenderer(null);
                outlookCaption.lf_type = outlookCaption.LF_METAL;
                jOutlookPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                jPanelOutlookContainer.repaint();
            }
        });
        jRadioButtonRenderer3.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jOutlookPanel.setOutlookTabHeaderRenderer(new BluePlasticOutlookTabHeaderRenderer());
                jOutlookPanel.setOutlookTabBodyRenderer(new BluePlasticOutlookTabBodyRenderer());
                jOutlookPanel.setOutlookButtonRenderer(new DefaultOutlookButtonRenderer());
                jOutlookPanel.setTabSpacing(0);
                jOutlookPanel.setOutlookScrollButtonUpRenderer(new DefaultOutlookScrollButtonRenderer(imageIconScrollUpS, imageIconScrollUp));
                jOutlookPanel.setOutlookScrollButtonDownRenderer(new DefaultOutlookScrollButtonRenderer(imageIconScrollDownS, imageIconScrollDown));
                outlookCaption.lf_type = outlookCaption.LF_PLASTIC;
                jOutlookPanel.setBorder(BorderFactory.createEmptyBorder());
                jPanelOutlookContainer.repaint();
            }
        });

        jRadioButtonRenderer2.doClick();

        Util.constrain(jPanelRenderer, jRadioButtonRenderer2,
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelRenderer, jRadioButtonRenderer3,
                1, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelRenderer, jRadioButtonRenderer1,
                1, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);


        final JCheckBox jCheckBoxAnimateOutlook = new JCheckBox("Animated tab movement");
        jCheckBoxAnimateOutlook.setSelected(jOutlookPanel.getDefaultPaintMode() == JOutlookPanel.MODE_ANIMATE);

        jCheckBoxAnimateOutlook.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (jCheckBoxAnimateOutlook.isSelected())
                    jOutlookPanel.setDefaultPaintMode(JOutlookPanel.MODE_ANIMATE);
                else
                    jOutlookPanel.setDefaultPaintMode(JOutlookPanel.MODE_DEFAULT);
            }
        });

        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jPanelRenderer,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 3, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxAnimateOutlook,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);
        Util.constrain(jPanelOptions, Box.createGlue(),
                0, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_OUTLOOK),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    private class OutlookBackground extends JLabel {
        private final ImageIcon imageBG = new ImageIcon(OutlookBackground.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/bg.gif"));

        public void paint(Graphics g) {
            int width = imageBG.getImage().getWidth(null);
            int height = imageBG.getImage().getHeight(null);
            for (int i = 0; i <= getWidth() + width; i += (width))
                for (int j = 0; j <= getHeight() + height; j += (height))
                    g.drawImage(imageBG.getImage(), i, j, width, height, this);
        }
    }

    private class OutlookCaption extends JPanel {
        public final int LF_METAL = 1;
        public final int LF_PLASTIC = 2;
        public final int LF_NATIVE = 3;
        public int lf_type = LF_NATIVE;
        private final ImageIcon imageBG = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/bg.gif"));
        private final ImageIcon imageCaption = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/caption.gif"));

        private final ImageIcon l_bg = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/caption_bg_left.gif"));
        private final ImageIcon r_bg = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/caption_bg_right.gif"));
        private final ImageIcon c_bg = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/caption_bg_center.gif"));
        private final ImageIcon imageCaption2 = new ImageIcon(OutlookCaption.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/BluePlasticOutlookRenderer/caption_text.gif"));


        protected void paintComponent(Graphics g) {
            if (lf_type == LF_NATIVE) {
                super.paintComponent(g);

                int cWidth = imageCaption.getImage().getWidth(null);
                int cHeight = imageCaption.getImage().getHeight(null);
                int i = getWidth() / 2 - cWidth / 2;
                int j = getHeight() / 2 - cHeight / 2;
                g.drawImage(imageCaption.getImage(), i, j, cWidth, cHeight, this);
                g.setColor(Color.black);
                g.drawLine(0, 0, getWidth(), 0);
                g.drawLine(0, 0, 0, getHeight());
                g.drawLine(getWidth() - 1, 0, getWidth() - 1, getHeight());
            } else if (lf_type == LF_METAL) {
                int bgWidth = imageBG.getImage().getWidth(null);
                int bgHeight = imageBG.getImage().getHeight(null);
                for (int i = 0; i <= getWidth() + bgWidth; i += (bgWidth))
                    for (int j = 0; j <= getHeight() + bgHeight; j += (bgHeight))
                        g.drawImage(imageBG.getImage(), i, j, bgWidth, bgHeight, this);

                int cWidth = imageCaption.getImage().getWidth(null);
                int cHeight = imageCaption.getImage().getHeight(null);
                int i = getWidth() / 2 - cWidth / 2;
                int j = getHeight() / 2 - cHeight / 2;
                g.drawImage(imageCaption.getImage(), i, j, cWidth, cHeight, this);
                g.setColor(Color.black);
                g.drawLine(0, 0, getWidth(), 0);
                g.drawLine(0, 0, 0, getHeight());
                g.drawLine(getWidth() - 1, 0, getWidth() - 1, getHeight());
            } else if (lf_type == LF_PLASTIC) {
                int l_bg_w = l_bg.getImage().getWidth(null);
                int l_bg_h = l_bg.getImage().getHeight(null);
                g.drawImage(l_bg.getImage(), 0, 0, l_bg_w, l_bg_h, this);

                int r_bg_w = r_bg.getImage().getWidth(null);
                int r_bg_h = r_bg.getImage().getHeight(null);
                int r_bg_x = getWidth() - r_bg_w;
                g.drawImage(r_bg.getImage(), r_bg_x, 0, r_bg_w, r_bg_h, this);

                int c_bg_x1 = l_bg_w;
                int c_bg_x2 = getWidth() - r_bg_w;
                int c_bg_w = c_bg.getImage().getWidth(null);
                int c_bg_h = c_bg.getImage().getHeight(null);
                g.drawImage(c_bg.getImage(), c_bg_x1, 0, c_bg_x2, c_bg_h, 0, 0, c_bg_w, c_bg_h, this);

                int cWidth = imageCaption2.getImage().getWidth(null);
                int cHeight = imageCaption2.getImage().getHeight(null);
                int i = getWidth() / 2 - cWidth / 2;
                int j = getHeight() / 2 - cHeight / 2;
                g.drawImage(imageCaption2.getImage(), i, j, cWidth, cHeight, this);
            }
        }
    }
}
