/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.asc.animatepanel.JAnimatePanel;
import com.smardec.asc.animatepanel.JAnimateTab;
import com.smardec.demo.asc.animatepanel.renderers.blueplastic.BluePlasticAnimatePanelRenderer;
import com.smardec.demo.asc.animatepanel.renderers.blueplastic.BluePlasticAnimateTabHeaderRenderer;
import com.smardec.demo.asc.animatepanel.renderers.metalwood.MetalWoodAnimatePanelRenderer;
import com.smardec.demo.asc.animatepanel.renderers.metalwood.MetalWoodAnimateTabHeaderRenderer;
import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class JAnimatePanelDemo extends DemoableAdapter {
    public final static String CONSTRAINT_ANIMATE = "Animate";
    public final static String CAPTION_ANIMATE = "JAnimatePanel";
    public final static String INTRO_ANIMATE = "<html><p align=left color=black>JAnimatePanel - easily customized component that allows to create user defined animated panels. The component supports custom renderers." +
            "<br>You can choose one of the custom renderers in the 'Options panel'. If 'No renderer' button is selected - specified project look&feel is used to render JOutlookPanel. To animate tab movement select 'Animate tab movement' checkbox.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JAnimatePanel jAnimatePanel;

    public String getID() {
        return CONSTRAINT_ANIMATE;
    }

    public String getCaption() {
        return CAPTION_ANIMATE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelAnimate = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_ANIMATE);
        titledBorder.setTitleColor(Color.black);
        jPanelAnimate.setBorder(titledBorder);

        jAnimatePanel = new JAnimatePanel();
        jAnimatePanel.setDelay(10);
        jAnimatePanel.setStep(30);
        jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
        jAnimatePanel.setBorder(BorderFactory.createEmptyBorder());
        JAnimateTab jAnimateTab;
        JList jList;

        final JAnimatePanel jAnimatePanel2 = new JAnimatePanel();
        jAnimatePanel2.setBlockEvents(false);
        jAnimatePanel2.setDelay(10);
        jAnimatePanel2.setStep(30);
        jAnimatePanel2.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
        jAnimatePanel2.setBorder(BorderFactory.createEmptyBorder());

        jList = new JList(new Object[]{"JOutlookPanel", "JAnimatePanel", "JXPMenu", "JSliderPanel", "JTreeTable"});
        jAnimateTab = new JAnimateTab("Tab 1", null, new JScrollPane(jList));
        jAnimatePanel2.addTab(jAnimateTab);

        jList = new JList(new Object[]{"SortedTableModel", "FilteredTableModel", "JQuickTree", "JAutoTextField", "JAutoComboBox"});
        jAnimateTab = new JAnimateTab("Tab 2", null, new JScrollPane(jList));
        jAnimatePanel2.addTab(jAnimateTab);

        jList = new JList(new Object[]{"QuickGradientPaint", "JSplashScreen", "JMemoryIndicator", "JHyperlinkLabel", "WideTreeCellEditor"});
        jAnimateTab = new JAnimateTab("Tab 3", null, new JScrollPane(jList));
        jAnimatePanel2.addTab(jAnimateTab);
        jAnimatePanel2.setPreferredSize(new Dimension(200, 200));

        jAnimatePanel.setBlockEvents(false);


        jList = new JList(new Object[]{"JOutlookPanel", "JAnimatePanel", "JXPMenu", "JSliderPanel", "JTreeTable"});
        jAnimateTab = new JAnimateTab("Tab 1", null, new JScrollPane(jAnimatePanel2));
        jAnimatePanel.addTab(jAnimateTab);

        jList = new JList(new Object[]{"SortedTableModel", "FilteredTableModel", "JQuickTree", "JAutoTextField", "JAutoComboBox"});
        jAnimateTab = new JAnimateTab("Tab 2", null, new JScrollPane(jList));
        jAnimatePanel.addTab(jAnimateTab);

        jList = new JList(new Object[]{"QuickGradientPaint", "JSplashScreen", "JMemoryIndicator", "JHyperlinkLabel", "WideTreeCellEditor"});
        jAnimateTab = new JAnimateTab("Tab 3", null, new JScrollPane(jList));
        jAnimatePanel.addTab(jAnimateTab);

        jAnimatePanel.setPreferredSize(new Dimension(200, jAnimatePanel.getPreferredSize().height));

        JPanel jPanelTmpAnimate = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jAnimatePanel, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jPanelTmpAnimate.add(jScrollPane, BorderLayout.CENTER);


        jPanelTmpAnimate.setPreferredSize(new Dimension(250, 100));
        Util.constrain(jPanelAnimate, jPanelTmpAnimate,
                0, 1, 1, 1, GridBagConstraints.VERTICAL, GridBagConstraints.NORTHWEST, 0.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelAnimate, Box.createGlue(),
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);


        return jPanelAnimate;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        JPanel jPanelRenderer = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select renderer:");
        titledBorder.setTitleColor(Color.black);
        jPanelRenderer.setBorder(titledBorder);
        JRadioButton jRadioButtonRenderer1 = new JRadioButton("No renderer");
        JRadioButton jRadioButtonRenderer2 = new JRadioButton("Renderer 1 ");
        JRadioButton jRadioButtonRenderer3 = new JRadioButton("Renderer 2 ");

        ButtonGroup group = new ButtonGroup();
        group.add(jRadioButtonRenderer1);
        group.add(jRadioButtonRenderer2);
        group.add(jRadioButtonRenderer3);

        jRadioButtonRenderer1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jAnimatePanel.setAnimateTabHeaderRenderer(null);
                jAnimatePanel.setAnimatePanelRenderer(null);
                jAnimatePanel.setTabSpacing(0);
            }
        });
        jRadioButtonRenderer2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jAnimatePanel.setAnimateTabHeaderRenderer(new MetalWoodAnimateTabHeaderRenderer());
                jAnimatePanel.setAnimatePanelRenderer(new MetalWoodAnimatePanelRenderer());
                jAnimatePanel.setTabSpacing(1);
            }
        });
        jRadioButtonRenderer3.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jAnimatePanel.setAnimateTabHeaderRenderer(new BluePlasticAnimateTabHeaderRenderer());
                jAnimatePanel.setAnimatePanelRenderer(new BluePlasticAnimatePanelRenderer());
                jAnimatePanel.setTabSpacing(0);
            }
        });

        jRadioButtonRenderer2.doClick();

        final JCheckBox jCheckBoxAnimateMode = new JCheckBox("Animated tab movement");
        jCheckBoxAnimateMode.setSelected(jAnimatePanel.getDefaultPaintMode() == JAnimatePanel.MODE_ANIMATE);

        jCheckBoxAnimateMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (jCheckBoxAnimateMode.isSelected())
                    jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
                else
                    jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_DEFAULT);
            }
        });

        Util.constrain(jPanelRenderer, jRadioButtonRenderer2,
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelRenderer, jRadioButtonRenderer3,
                1, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelRenderer, jRadioButtonRenderer1,
                1, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);

        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jPanelRenderer,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 3, 0, 5);

        Util.constrain(jPanelOptions, jCheckBoxAnimateMode,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 1, 0, 5);
        
        Util.constrain(jPanelOptions, Box.createGlue(),
                0, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_ANIMATE),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
