/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.fontchooser.JFontChooser;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class FontDemo extends DemoableAdapter {
    public final static String CONSTRAINT_FONT_CHOOSER = "FontChooser";
    public final static String CAPTION_FONT_CHOOSER = "Font components";
    public final static String INTRO_FONT_CHOOSER = "<html><p align=left color=black>JFontChooser provides a simple and powerful mechanism for the user to choose a font." +
            "<br>It supports custom preview string and control buttons. Click 'Show font chooser dialog' button to view demo.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private JTextField jTextFieldPreviewString;
    private JCheckBox jCheckBoxShowControlButton;

    private Component parentFrame;
    private JFontChooser jFontChooser;

    public String getID() {
        return CONSTRAINT_FONT_CHOOSER;
    }

    public String getCaption() {
        return CAPTION_FONT_CHOOSER;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NEW;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_FONT_CHOOSER);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);

        JButton jButtonShowChoser = new JButton("Show font chooser dialog");
        jButtonShowChoser.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    jFontChooser = new JFontChooser(new Font("Verdana", Font.BOLD | Font.ITALIC, 14));
                    jFontChooser.setControlButtonsShown(jCheckBoxShowControlButton.isSelected());
                    jFontChooser.setPreviewString(jTextFieldPreviewString.getText());
                    int res = jFontChooser.showDialog(parentFrame);
                    System.out.println("jFontChooser.getSelectedFont() = " + jFontChooser.getSelectedFont());
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel.add(jButtonShowChoser);

        Util.constrain(jPanelContents, jPanel,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelContents, Box.createGlue(),
                0, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 0, 0, 0);
        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        jTextFieldPreviewString = new JTextField();
        jCheckBoxShowControlButton = new JCheckBox("Show control buttons", true);

        jPanelOptions = new JPanel(new GridBagLayout());
        JPanel jPanelPreview = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Specify preview string:");
        titledBorder.setTitleColor(Color.black);
        jPanelPreview.setBorder(titledBorder);
        Util.constrain(jPanelPreview, jTextFieldPreviewString,
                0, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.5, 0.0,
                0, 3, 0, 5);

        Util.constrain(jPanelOptions, jPanelPreview,
                0, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.5, 0.0,
                0, 3, 0, 5);
        Util.constrain(jPanelOptions, jCheckBoxShowControlButton,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.5, 0.0,
                5, 1, 0, 5);

        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_FONT_CHOOSER),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    public void init(Component parentFrame) {
        this.parentFrame = parentFrame;
    }
}
