/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.filechooser.FileChooserManager;
import com.smardec.asc.filechooser.JAscFileChooser;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class FileChooserDemo extends DemoableAdapter {
    public final static String CONSTRAINT_FILE_CHOOSER = "FileChooser";
    public final static String CAPTION_FILE_CHOOSER = "XML FileChooser";
    public final static String INTRO_FILE_CHOOSER = "<html><p align=left color=black>FileChooserManager builds and configures file choosers and filters from XML, AscFileFilter provides advance filtering with mask support, JAscFileChooser - JFileChooser that supports loading from XML." +
            "<br><br>Click 'Show file chooser' button to view demo file chooser built and configured from xml.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private FileChooserManager fileChooserManager;
    private Component parentFrame;
    private JRadioButton jRadioButtonFilterXML;
    private JRadioButton jRadioButtonFilterHTML;


    public String getID() {
        return CONSTRAINT_FILE_CHOOSER;
    }

    public String getCaption() {
        return CAPTION_FILE_CHOOSER;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NEW;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_FILE_CHOOSER);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);

        JButton jButtonShowChoser = new JButton("Show file chooser");
        jButtonShowChoser.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    if (fileChooserManager == null) {
                        fileChooserManager = new FileChooserManager(getClass().getClassLoader().getResourceAsStream("com/smardec/demo/asc/filechoosers.xml"));
                        fileChooserManager.buildFileChooser();
                    }
                    JAscFileChooser fileChooser = null;
                    if (fileChooserManager != null) {
                        if (jRadioButtonFilterXML.isSelected())
                            fileChooser = fileChooserManager.getFileChooserById("FileChooser.Xml");
                        if (jRadioButtonFilterHTML.isSelected())
                            fileChooser = fileChooserManager.getFileChooserById("FileChooser.Html");
                        if (fileChooser != null)
                            fileChooser.showOpenDialog(parentFrame);
                    }
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel.add(jButtonShowChoser);

        Util.constrain(jPanelContents, jPanel,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelContents, Box.createGlue(),
                0, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 0, 0, 0);
        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;
        JPanel jPanelFilter = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Select file choser filter:");
        titledBorder.setTitleColor(Color.black);
        jPanelFilter.setBorder(titledBorder);

        jRadioButtonFilterXML = new JRadioButton("XML file filter");
        jRadioButtonFilterHTML = new JRadioButton("HTML file filter");

        ButtonGroup group = new ButtonGroup();
        group.add(jRadioButtonFilterXML);
        group.add(jRadioButtonFilterHTML);

        jRadioButtonFilterXML.doClick();

        Util.constrain(jPanelFilter, jRadioButtonFilterXML,
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelFilter, jRadioButtonFilterHTML,
                1, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);

        jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(jPanelOptions, jPanelFilter,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 3, 0, 5);
        return jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_FILE_CHOOSER),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }

    public void init(Component parentFrame) {
        this.parentFrame = parentFrame;
    }
}
