/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.dropdown.JDropDownButton;
import com.smardec.asc.xmlbars.MenuToolBarManager;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;

public class DropDownDemo extends DemoableAdapter {
    public final static String CONSTRAINT_DROP_DOWN = "Drop-down button";
    public final static String CAPTION_DROP_DOWN = "Drop-down button";
    public final static String INTRO_DROP_DOWN = "<html><p align=left color=black>JDropDownButton - JButton that provides popup menu with alternate actions. " +
            "It supports selectable and fixed actions. In case of selectable action usage - drop-down button switch default action to selected one. In case of fixed action usage alternate actions available only from popup menu. " +
            "Also JDropDownButton can be used as a toolbar button.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    private MenuToolBarManager menuToolBarManager;

    public String getID() {
        return CONSTRAINT_DROP_DOWN;
    }

    public String getCaption() {
        return CAPTION_DROP_DOWN;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NEW;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_DROP_DOWN);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);

        JPanel jPanelExample = new JPanel(new GridBagLayout());
//        titledBorder = BorderFactory.createTitledBorder("JDropDownButton samples:");
//        titledBorder.setTitleColor(Color.black);
//        jPanelExample.setBorder(titledBorder);

        Vector v = new Vector();
        try {
            if (menuToolBarManager == null) {
                menuToolBarManager = new MenuToolBarManager(getClass().getClassLoader().getResourceAsStream("com/smardec/demo/asc/menutoolbar.xml"));
                menuToolBarManager.buildMenuAndToolbar();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (menuToolBarManager != null) {
            v.add(menuToolBarManager.getActionById("File.New"));
            v.add(menuToolBarManager.getActionById("File.Open"));
            v.add(menuToolBarManager.getActionById("File.Save"));
            v.add(menuToolBarManager.getActionById("File.Refresh"));
            v.add(menuToolBarManager.getActionById("File.Close"));
        }
        JDropDownButton jDropDownButton = null;
        try {
            jDropDownButton = new JDropDownButton(v);
            jDropDownButton.setPreferredSize(new Dimension(120, 26));
        } catch (Exception e) {
            e.printStackTrace();
        }
        JDropDownButton jDropDownButton2 = null;
        try {
            jDropDownButton2 = new JDropDownButton(v);
            jDropDownButton2.setPreferredSize(new Dimension(120, 26));
            jDropDownButton2.setChangeActiveAction(false);
        } catch (Exception e) {
            e.printStackTrace();
        }

        JDropDownButton jDropDownButtonToolBar = null;
        try {
            jDropDownButtonToolBar = new JDropDownButton(v, true);
            jDropDownButtonToolBar.setPreferredSize(new Dimension(26 + 14, 26));
        } catch (Exception e) {
            e.printStackTrace();
        }
        JPanel jPanel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel1.setBorder(BorderFactory.createTitledBorder("Button with selectable action"));
        jPanel1.add(jDropDownButton);
//        jPanel1.add(new JLabel("<html><p align=left color=black> - button with selectable action</p></html>"));

        JPanel jPanel2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Button with fixed action"));
        jPanel2.add(jDropDownButton2);
//        jPanel2.add(new JLabel("<html><p align=left color=black> - button with fixed action</p></html>"));

        JPanel jPanel3 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Toolbar style button"));
        jPanel3.add(jDropDownButtonToolBar);
//        jPanel3.add(new JLabel("<html><p align=left color=black> - toolbar style button</p></html>"));

        Util.constrain(jPanelExample, jPanel1,
                1, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelExample, jPanel2,
                1, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);
        Util.constrain(jPanelExample, jPanel3,
                1, 3, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 0, 0, 0);


        Util.constrain(jPanelContents, jPanelExample,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 5, 5);
        Util.constrain(jPanelContents, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 0, 0, 0);
        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        return null;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_DROP_DOWN),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
