/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import com.smardec.asc.hyperlink.JHyperlinkLabel;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;

public class ContentDemo extends DemoableAdapter {
    public final static String CONSTRAINT_CONTENTS = "Contents";
    public final static String CAPTION_CONTENTS = "Contents";
    private final String INTRO_CONTENTS = "<html><p color=black>Advanced Swing Components Suite contains the following components:" +
            "<table cellspacing=2 cellpadding=2 border=0>" +
            "<tr><td valign=top color=black colspan=2><b>Animated Swing components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JOutlookPanel&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td color=black>Microsoft Outlook-style component with custom renderers support</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JSliderPanel</td><td color=black>Component that allows to create sliding panels with various settings</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAnimatePanel</td><td color=black>Easily customized component that allows to create user defined animated panels</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JXPMenu</td><td color=black>Open source component which demonstrates the usage of JAnimatePanel</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>JTreeTable component</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JTreeTable</td><td color=black>TreeTable Swing component that combines JTable and JTree</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>JSpanTable component</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JSpanTable</td><td color=black>JSpanTable - Swing component based on JTable that provides api to create table with cell span</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Sortable and filterable JTable</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;SortedTableModel</td><td color=black>TableModel with sorting support</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;FilteredTableModel</td><td color=black>TableModel with filtering support</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Components with quick search support</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JQuickTree</td><td color=black>JTree component with quick search capabilities and enhanced navigation</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JQuickTable</td><td color=black>JTable with quick search capabilities</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JQuickList</td><td color=black>JList with quick search capabilities</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JQuickTextArea</td><td color=black>JTextArea with quick search capabilities</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Autocomplete components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAutoTextField</td><td color=black>JTextField with autocomplete support</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAutoComboBox</td><td color=black>JComboBox with autocomplete support</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Toolbar & Menubar</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;MenuToolBarManager</td><td color=black>Builds and configures toolbar and menu from XML</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAscToolBar</td><td color=black>JToolBar with advanced layout and extended controls</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;ToolbarDockLayout</td><td color=black>LayoutManager with different styles for dockable toolbars</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Hyperlink utilities</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;HyperlinkUtil</td><td color=black>Cross-platform utils for launching internet browser</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JHyperlinkLabel</td><td color=black>JLabel that displays hyperlink and opens internet browser on mouse click</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Splash screen component</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JSplashScreen</td><td color=black>Configurable splash screen</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;Hyperlink utilities</td><td color=black>Hyperlink utility classes</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Statusbar</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JMemoryIndicator</td><td color=black>Virtual machine memory indicator</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Vertical components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JVerticalButton</td><td color=black>JButton with rotation support</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JVerticalToggleButton</td><td color=black>JToggleButton with rotation support</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JVerticalLabel</td><td color=black>JLabel with rotation support</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Font components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JFontChooser</td><td color=black>Provides a simple mechanism for the user to choose a font</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>File components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAscFileChooser</td><td color=black>JFileChooser that supports loading from XML</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;FileChooserManager</td><td color=black>Builds and configures file choosers and filters from XML</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;AscFileFilter</td><td color=black>Advanced FileFilter with mask support</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Drop down components</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JDropDownButton</td><td color=black>JButton that provides popup menu with alternate actions</td></tr>" +
            "<tr><td valign=top color=black colspan=2><b>Utility classes</b></td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;QuickGradientPaint</td><td color=black>Optimized Paint for gradients</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;WideTreeCellEditor</td><td color=black>An editor that has tree object's width</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAscFrame</td><td color=black>JFrame that handles \"Enter\" and \"Escape\" key presses</td></tr>" +
            "<tr><td valign=top color=black>&nbsp;&nbsp;JAscDialog</td><td color=black>JDialog that handles \"Enter\" and \"Escape\" key presses</td></tr>" +
            "</table>" +
            "</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    public String getID() {
        return CONSTRAINT_CONTENTS;
    }

    public String getCaption() {
        return CAPTION_CONTENTS;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelContents = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_CONTENTS);
        titledBorder.setTitleColor(Color.black);
        jPanelContents.setBorder(titledBorder);
        JEditorPane jEditorPane = new JEditorPane("text/html", INTRO_CONTENTS);
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        jEditorPane.setBackground(jPanelContents.getBackground());
        Util.constrain(jPanelContents, new JScrollPane(jEditorPane),
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1, 1,
                0, 5, 0, 5);

        return jPanelContents;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;
        return null;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;
        return null;
    }
}
