/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.asc.autocomplete.JAutoComboBox;
import com.smardec.asc.autocomplete.JAutoTextField;
import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;

public class AutoCompleteDemo extends DemoableAdapter {
    public final static String CONSTRAINT_AUTO_COMPLETE = "AutoComplete";
    public final static String CAPTION_AUTO_COMPLETE = "AutoComplete";
    public final static String INTRO_AUTO_COMPLETE = "<html><p align=left color=black>JAutoComboBox and JAutoTextField - JComboBox and JTextField components with autocomplete support.</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    public static java.util.List languages = Arrays.asList(new Object[]{
            "Afrikaans", "Albanian", "Amharic", "Arabic", "Azerbaijani", "Basque", "Belarusian", "Bengali", "Bihari",
            "Bosnian", "Breton", "Bulgarian", "Catalan", "Chinese (Simplified)", "Chinese (Traditional)", "Croatian",
            "Czech", "Danish", "Dutch", "Elmer Fudd", "English", "Esperanto", "Estonian", "Faroese", "Filipino", "Finnish",
            "French", "Frisian", "Galician", "Georgian", "German", "Greek", "Guarani", "Gujarati", "Hebrew", "Hindi",
            "Hungarian", "Icelandic", "Indonesian", "Interlingua", "Irish", "Italian", "Japanese", "Javanese", "Kannada",
            "Klingon", "Korean", "Kyrgyz", "Latin", "Latvian", "Lithuanian", "Macedonian", "Malay", "Malayalam", "Maltese",
            "Marathi", "Nepali", "Norwegian", "Norwegian (Nynorsk)", "Occitan", "Oriya", "Persian", "Pig Latin", "Polish",
            "Portuguese (Brazil) ", "Portuguese (Portugal) ", "Punjabi", "Romanian", "Russian", "Scots Gaelic", "Serbian",
            "Serbo-Croatian", "Sesotho", "Sinhalese", "Slovak", "Slovenian", "Spanish", "Sundanese", "Swahili", "Swedish",
            "Tamil", "Telugu", "Thai", "Tigrinya", "Turkish", "Turkmen", "Twi", "Ukrainian", "Urdu", "Uzbek", "Vietnamese",
            "Welsh", "Xhosa", "Yiddish", "Zulu"
    });


    public String getID() {
        return CONSTRAINT_AUTO_COMPLETE;
    }

    public String getCaption() {
        return CAPTION_AUTO_COMPLETE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_UPDATED;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelAutoComplete = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_AUTO_COMPLETE);
        titledBorder.setTitleColor(Color.black);
        jPanelAutoComplete.setBorder(titledBorder);

        JLabel jLabel1 = new JLabel("JAutoTextField with strict editing:");
        jLabel1.setForeground(Color.black);
        Util.constrain(jPanelAutoComplete, jLabel1,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 5, 0, 5);
        JAutoTextField jAutoTextFieldStrict = new JAutoTextField(languages);
        Util.constrain(jPanelAutoComplete, jAutoTextFieldStrict,
                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 5, 0, 0);
        JLabel jLabel2 = new JLabel("JAutoTextField with non-strict editing:");
        jLabel2.setForeground(Color.black);
        Util.constrain(jPanelAutoComplete, jLabel2,
                1, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                0, 20, 0, 5);
        JAutoTextField jAutoTextFieldNonStrict = new JAutoTextField(languages);
        jAutoTextFieldNonStrict.setStrict(false);
        Util.constrain(jPanelAutoComplete, jAutoTextFieldNonStrict,
                1, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 20, 0, 5);

        JLabel jLabel3 = new JLabel("JAutoComboBox with strict editing:");
        jLabel3.setForeground(Color.black);
        Util.constrain(jPanelAutoComplete, jLabel3,
                0, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                20, 5, 0, 5);
        JAutoComboBox jAutoComboBoxStrict = new JAutoComboBox(languages);
        Util.constrain(jPanelAutoComplete, jAutoComboBoxStrict,
                0, 4, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 5, 0, 0);
        JLabel jLabel4 = new JLabel("JAutoComboBox with non-strict editing:");
        jLabel4.setForeground(Color.black);
        Util.constrain(jPanelAutoComplete, jLabel4,
                1, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                20, 20, 0, 5);
        JAutoComboBox jAutoComboBoxNonStrict = new JAutoComboBox(languages);
        jAutoComboBoxNonStrict.setStrict(false);
        Util.constrain(jPanelAutoComplete, jAutoComboBoxNonStrict,
                1, 4, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                5, 20, 0, 5);

        Vector row = new Vector();
        row.add(languages.get(0));
        row.add(languages.get(0));
        Vector data = new Vector();
        data.add(row);
        data.add(row.clone());
        Vector columnNames = new Vector();
        columnNames.add("");
        columnNames.add("");
        JTable jTable = new JTable(data, columnNames) {
            public TableCellEditor getCellEditor(int row, int column) {
                if (row == 0) {
                    JAutoTextField jAutoTextField = new JAutoTextField(languages);
                    if (column == 1)
                        jAutoTextField.setStrict(false);
                    return new DefaultCellEditor(jAutoTextField);
                } else {
                    JAutoComboBox jAutoComboBox = new JAutoComboBox(languages);
                    if (column == 1)
                        jAutoComboBox.setStrict(false);
                    return new DefaultCellEditor(jAutoComboBox);
                }
            }
        };
        JLabel jLabel5 = new JLabel("Standard JTable with JAutoTextField and JAutoComboBox as editors:");
        jLabel5.setForeground(Color.black);
        Util.constrain(jPanelAutoComplete, jLabel5,
                0, 5, 2, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0.0,
                30, 5, 0, 5);
        Util.constrain(jPanelAutoComplete, jTable,
                0, 6, 2, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        return jPanelAutoComplete;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;

        return null;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;

        jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(jPanelDesc, new JLabel(INTRO_AUTO_COMPLETE),
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);
        Util.constrain(jPanelDesc, Box.createGlue(),
                0, 2, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);
        return jPanelDesc;
    }
}
