/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc.demos;

import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.asc.hyperlink.JHyperlinkLabel;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;

public class AboutDemo extends DemoableAdapter {
    public final static String CONSTRAINT_ABOUT = "About";
    public final static String CAPTION_ABOUT = "About";
    public final static String INTRO_ABOUT = "<html><p color=black>&nbsp;&nbsp;&nbsp;&nbsp;Advanced Swing Components are 100% Swing-based components that help you to deliver Swing applications with professional and user-friendly interface. They are used by developers, who prefer to create own applications as fast as possible with the guarantee of high quality and outstanding performance. Advanced Swing Components fit all popular look and feels.<br>&nbsp;&nbsp;&nbsp;&nbsp;Components are continually enhanced and improved upon and new versions are released frequently to ensure that you always have the most up-to-date and fully supported version available.<br>&nbsp;&nbsp;&nbsp;&nbsp;We can also implement new Swing components on request and add them to the Suite." +
            " <br><br>Advantages:" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Extremely flexible and powerful" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Easy to use" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Complete documentation" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Partly open source" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Compatible with JDK 1.3, JDK 1.4, JDK 1.5, JDK 1.6 and JDK 1.7" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Free email support for 12 months" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;Free updates and upgrades for 12 months" +
            " <br>&nbsp;&nbsp;-&nbsp;&nbsp;No royalty or runtime fees" +
            "</p></html>";

    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    public String getID() {
        return CONSTRAINT_ABOUT;
    }

    public String getCaption() {
        return CAPTION_ABOUT;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return STATE_NONE;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelAbout = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_ABOUT);
        titledBorder.setTitleColor(Color.black);
        jPanelAbout.setBorder(titledBorder);
        jPanelAbout.setBorder(titledBorder);


        Util.constrain(jPanelAbout, new JLabel(INTRO_ABOUT),
                0, 0, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
                0, 5, 0, 0);
        JPanel jPanelLink = new JPanel(new GridBagLayout());

        Util.constrain(jPanelLink, new JLabel("Links:"),
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                0, 5, 0, 0);

        Util.constrain(jPanelLink, new JLabel(" -  Smardec web site:"),
                0, 1, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                0, 8, 0, 0);
        Util.constrain(jPanelLink, new JHyperlinkLabel("http://www.smardec.com", "http://www.smardec.com"),
                1, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0,
                0, 5, 0, 0);
        Util.constrain(jPanelLink, new JLabel(" -  ASC web page:"),
                0, 2, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                0, 8, 0, 0);
        Util.constrain(jPanelLink, new JHyperlinkLabel("http://www.smardec.com/products/asc.html", "http://www.smardec.com/products/asc.html"),
                1, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0,
                1, 5, 0, 0);
        Util.constrain(jPanelLink, new JLabel(" -  Obfuscation by Allatori:"),
                0, 3, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0, 0,
                0, 8, 0, 0);
        Util.constrain(jPanelLink, new JHyperlinkLabel("http://www.allatori.com", "http://www.allatori.com"),
                1, 3, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1.0, 0,
                0, 5, 0, 0);

        Util.constrain(jPanelAbout, jPanelLink,
                0, 1, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 1.0,
                10, 0, 0, 0);

//        JPanel jPanelLink = new JPanel(new FlowLayout(FlowLayout.RIGHT, 0, 0));
//        jPanelLink.add(new JHyperlinkLabel("http://www.smardec.com", "http://www.smardec.com"));
//        Util.constrain(jPanelAbout, jPanelLink,
//                0, 2, 1, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 1, 0,
//                0, 0, 5, 5);
        return jPanelAbout;
    }

    public JPanel getOptionPanel() {
        if (jPanelOptions != null)
            return jPanelOptions;
        return null;
    }

    public JPanel getDescriptionPanel() {
        if (jPanelDesc != null)
            return jPanelDesc;
        return null;
    }
}
