/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc;

import javax.swing.*;
import java.awt.*;

public class Util {
    public static void constrain(Container container, Component component,
                                 int x, int y, int width, int height, int fill, int anchor, double weightx, double weighty,
                                 int insetTop, int insetLeft, int insetBottom, int insetRight) {
        Insets insets = new Insets(insetTop, insetLeft, insetBottom, insetRight);
        GridBagConstraints gbc = new GridBagConstraints(x, y, width, height, weightx, weighty, anchor, fill, insets, 0, 0);
        LayoutManager lm = container.getLayout();
        GridBagLayout gbl = (GridBagLayout) lm;
        gbl.setConstraints(component, gbc);
        container.add(component);
    }

    public static void centerOnScreen(Component component) {
        if (component == null)
            return;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();        

        Dimension compSize = component.getSize();
        if (compSize.height > screenSize.height)
            compSize.height = screenSize.height;
        if (compSize.width > screenSize.width)
            compSize.width = screenSize.width;
        component.setSize(compSize);
        component.setLocation((screenSize.width - compSize.width) / 2, (screenSize.height - compSize.height) / 2);
    }
}
