/*
  This software is the confidential and proprietary information of
  Smardec. You shall not disclose or distribute such Confidential Information.
  This software shall not be integrated, copied (partially or fully),
  or reverse engineered into any other software, program, or code that is
  not intended for Smardec. You shall use it only in accordance with the terms
  of the license agreement you entered into with Smardec.

  Copyright (C) 2003-2006 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.demo.asc;

import com.smardec.asc.animatepanel.JAnimatePanel;
import com.smardec.asc.animatepanel.JAnimateTab;
import com.smardec.asc.rotate.JVerticalToggleButton;
import com.smardec.asc.rotate.RotateConstants;
import com.smardec.asc.sliderpanel.JSliderPanel;
import com.smardec.asc.sliderpanel.JSliderPanelContainer;
import com.smardec.asc.splashscreen.JSplashScreen;
import com.smardec.asc.statusbar.JMemoryIndicator;
import com.smardec.demo.asc.demos.AboutDemo;
import org.w3c.dom.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.util.Enumeration;
import java.util.Hashtable;


public class Demo extends JFrame {
    private static InputStream demoInputStream = Demo.class.getClassLoader().getResourceAsStream("com/smardec/demo/asc/demos.xml");
    private final ImageIcon imageNew = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/new.gif"));
    private final ImageIcon imageUpdated = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/updated.gif"));
    private final ImageIcon imageSplash = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/splash.gif"));
    private final ImageIcon imageIcon16 = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/icon16.gif"));

    private class DemoTreeNode extends DefaultMutableTreeNode {
        private String constraint;

        public DemoTreeNode(Object userObject, String constraint) {
            super(userObject);
            this.constraint = constraint;
        }

        public String getConstraint() {
            return constraint;
        }
    }

    private class DemoCellRenderer extends DefaultTreeCellRenderer {
        public DemoCellRenderer() {
            setLeafIcon(null);
            setOpenIcon(null);
            setClosedIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JPanel jPanel = null;
            try {
                JLabel treeCellRendererComponent = (JLabel) super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                JLabel iconLabel = new JLabel();
                iconLabel.setVerticalAlignment(CENTER);
                treeCellRendererComponent.setVerticalAlignment(CENTER);
                String constraint = ((DemoTreeNode) value).getConstraint();
                if (constraint.equals(CONSTRAINT_ROOT))
                    return treeCellRendererComponent;
                Demoable demoable = (Demoable) constraint2demoble.get(constraint);
                if (demoable.getState() == Demoable.STATE_NONE)
                    iconLabel.setIcon(null);
                else if (demoable.getState() == Demoable.STATE_NEW)
                    iconLabel.setIcon(imageNew);
                else if (demoable.getState() == Demoable.STATE_UPDATED)
                    iconLabel.setIcon(imageUpdated);
                jPanel = new JPanel(new FlowLayout(FlowLayout.LEFT, 1, 1));
                jPanel.setOpaque(false);
                jPanel.add(treeCellRendererComponent);
                jPanel.add(iconLabel);
            } catch (Exception e) {
                e.printStackTrace();
            }

//            treeCellRendererComponent.setComponentOrientation();
            return jPanel;
        }
    }

    private Reader xmlReader = null;

    private JPanel jPanelDemo;

    private JPanel jPanelDemoEx;
    private JPanel jPanelRightControl;
    private JPanel jPanelDemoOption;
    private JPanel jPanelDemoDescription;
    boolean rightSliderVisible = true;

    private String currentConstraint;

    private JTree jTreeDemo;
    private Hashtable constraint2treenode;
    private Hashtable constraint2demoble;

    private static final String CONSTRAINT_ROOT = "root";
    private static final String CAPTION_ROOT = "root";

    private JSliderPanelContainer jSliderPanelContainer;
    private JAnimatePanel jAnimatePanel;
    private JAnimateTab jAnimateTabOptions;
    private JAnimateTab jAnimateTabDescriptions;

    public Demo(String xmlFileName) throws Exception {
        xmlReader = getXMLReader(xmlFileName);
        initLocalVars();
    }

    public Demo(InputStream inputStream) throws Exception {
        xmlReader = getXMLReader(inputStream);
        initLocalVars();
    }

    protected void initLocalVars() {
    }

    protected void init() {
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setTitle("Advanced Swing Components Demo");
        if (imageIcon16 != null)
            setIconImage(imageIcon16.getImage());
        setJMenuBar(getMainMenu());

        JVerticalToggleButton jVerticalToggleButtonLeft = new JVerticalToggleButton("Demo structure", RotateConstants.ROTATE_LEFT);

        JVerticalToggleButton jVerticalToggleButtonRight = new JVerticalToggleButton("Descriptions & Options", RotateConstants.ROTATE_RIGHT);

        jVerticalToggleButtonLeft.setSelected(true);

        jVerticalToggleButtonRight.setSelected(true);

        JPanel jPanelLeftControl;
        jPanelLeftControl = new JPanel(new GridBagLayout());
        Util.constrain(jPanelLeftControl, jVerticalToggleButtonLeft,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0, 0.0,
                9, 4, 5, 2);
        Util.constrain(jPanelLeftControl, Box.createGlue(),
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);

        jPanelRightControl = new JPanel(new GridBagLayout());
        Util.constrain(jPanelRightControl, jVerticalToggleButtonRight,
                0, 0, 1, 1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0, 0.0,
                9, 2, 5, 4);
        Util.constrain(jPanelRightControl, Box.createGlue(),
                0, 1, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);

        final JPanel jPanelTree = getPanelTree(xmlReader);
        JPanel jPanelDemo = getPanelDemo();
        final JPanel jPanelDemoEx = getPanelDemoEx();

        jSliderPanelContainer = new JSliderPanelContainer();
        jSliderPanelContainer.addBaseComponent(jPanelDemo);


        jSliderPanelContainer.getLeftSlider().addSliderContent(jPanelTree);
        jSliderPanelContainer.getLeftSlider().setMenuBarVisible(false);
        jSliderPanelContainer.getLeftSlider().setDock(true);
        jSliderPanelContainer.getLeftSlider().setPin(true);

        jSliderPanelContainer.getRightSlider().addSliderContent(jPanelDemoEx);
        jSliderPanelContainer.getRightSlider().setMenuBarVisible(false);
        jSliderPanelContainer.getRightSlider().setDock(true);
        jSliderPanelContainer.getRightSlider().setPin(true);

        jVerticalToggleButtonLeft.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelLeft = jSliderPanelContainer.getLeftSlider();
                if (!jSliderPanelLeft.isVisible()) {
                    try {
                        jSliderPanelLeft.setMenuBarVisible(false);
                        jSliderPanelLeft.setDock(true);
                        jSliderPanelLeft.setPin(true);

                        jSliderPanelContainer.showPanelLeft(jPanelTree, JSliderPanel.MODE_ANIMATE);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelLeft.isSliderHiding())
                            jSliderPanelContainer.hidePanelLeft(JSliderPanel.MODE_ANIMATE);
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        jVerticalToggleButtonRight.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JSliderPanel jSliderPanelRight = jSliderPanelContainer.getRightSlider();
                if (!jSliderPanelRight.isVisible()) {
                    try {
                        jSliderPanelRight.setMenuBarVisible(false);
                        jSliderPanelRight.setDock(true);
                        jSliderPanelRight.setPin(true);

                        jSliderPanelContainer.showPanelRight(jPanelDemoEx, JSliderPanel.MODE_ANIMATE);
                        rightSliderVisible = true;
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelRight.isSliderHiding()) {
                            jSliderPanelContainer.hidePanelRight(JSliderPanel.MODE_ANIMATE);
                            rightSliderVisible = false;
                        }
                    } catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });

        getContentPane().setLayout(new BorderLayout());

        JPanel jPanelContainer = new JPanel(new GridBagLayout());

        Util.constrain(jPanelContainer, jSliderPanelContainer,
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                2, 2, 5, 2);

        getContentPane().add(jPanelContainer, BorderLayout.CENTER);
        getContentPane().add(jPanelLeftControl, BorderLayout.WEST);
        getContentPane().add(jPanelRightControl, BorderLayout.EAST);
        JMemoryIndicator jMemoryIndicator = new JMemoryIndicator(new Dimension(100, 20), 1000, null, BorderFactory.createLineBorder(Color.black));
        JPanel jPanelMemory = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        jPanelMemory.add(jMemoryIndicator);
        getContentPane().add(jPanelMemory, BorderLayout.SOUTH);

        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.width < 950 || screenSize.height < 600)
            ((JComponent) (getContentPane())).setPreferredSize(new Dimension(screenSize.width - 20, screenSize.height - 100));
        else
            ((JComponent) (getContentPane())).setPreferredSize(new Dimension(950, 600));

        setActiveDemo(AboutDemo.CONSTRAINT_ABOUT);
    }

    public void showSplash(int displayTime) {
        final JSplashScreen splash = new JSplashScreen(this);
        splash.setImage(imageSplash);
        splash.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        splash.setCloseOnClick(true);
        splash.setMinimumDisplayTime(0);
        splash.setDisplayTime(displayTime);
        splash.setHyperlinkRectangle(new Rectangle(13, 226, 108, 12));
        splash.setUrl("http://www.smardec.com");
        splash.showSplash();
    }

    private DemoTreeNode addDemoTreeNode(String caption, String constraint, DemoTreeNode root) {
        DemoTreeNode tn;
        tn = new DemoTreeNode(caption, constraint);
        constraint2treenode.put(constraint, tn);
        if (root != null)
            root.add(tn);
        return tn;
    }

    private static Reader getXMLReader(String name) throws Exception {
        return new BufferedReader(new FileReader(name));
    }

    private static Reader getXMLReader(InputStream inputStream) throws Exception {
        return new InputStreamReader(inputStream);
    }

    private Demoable loadDemo(Node nodeDemo, DemoTreeNode rootTreeNode) throws Exception, IllegalAccessException, InstantiationException {
        Demoable demoable;
        NamedNodeMap attributes = nodeDemo.getAttributes();
        if (attributes.getNamedItem("class") != null) {
            String demoClassName = attributes.getNamedItem("class").getNodeValue();
            Class demoClass;
            try {
                demoClass = Class.forName(demoClassName);
            } catch (NoClassDefFoundError e) {
                return null;
            } catch (ClassNotFoundException e2) {
                return null;
            }
            demoable = (Demoable) demoClass.newInstance();
            demoable.init(Demo.this);
        } else
            throw new Exception("Failed creating demo. Required attribute 'class' is missing");

        DemoTreeNode tn = addDemoTreeNode(demoable.getCaption(), demoable.getID(), rootTreeNode);

        NodeList nodeListItems = nodeDemo.getChildNodes();
        for (int i = 0; i < nodeListItems.getLength(); i++)
            if ("demo".equalsIgnoreCase(nodeListItems.item(i).getNodeName())) {
                Demoable demoableChild = loadDemo(nodeListItems.item(i), tn);
                if (demoableChild != null) {
                    if (constraint2demoble.get(demoableChild.getID()) != null)
                        throw new Exception("Failed creating demo tree. Demo id must be unique. Id '" + demoableChild.getID() + "' is duplicated.");
                    constraint2demoble.put(demoableChild.getID(), demoableChild);
                }
            }
        return demoable;
    }

    private JPanel getPanelTree(Reader reader) {
        constraint2treenode = new Hashtable();
        constraint2demoble = new Hashtable();
        DemoTreeNode rootTreeNode = null;

        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));

            Element root = document.getDocumentElement();

            rootTreeNode = addDemoTreeNode(CAPTION_ROOT, CONSTRAINT_ROOT, null);

            NodeList nodeListDemo = root.getChildNodes();
            for (int i = 0; i < nodeListDemo.getLength(); i++) {
                if ("demo".equalsIgnoreCase(nodeListDemo.item(i).getNodeName())) {
                    Demoable demoable = loadDemo(nodeListDemo.item(i), rootTreeNode);
                    if (constraint2demoble.get(demoable.getID()) != null)
                        throw new Exception("Failed creating demo tree. Demo id must be unique. Id '" + demoable.getID() + "' is duplicated.");
                    constraint2demoble.put(demoable.getID(), demoable);
                }
            }
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }

        jTreeDemo = new JTree(new DefaultTreeModel(rootTreeNode));
        jTreeDemo.setEditable(false);
        jTreeDemo.setRootVisible(false);
        jTreeDemo.setCellRenderer(new DemoCellRenderer());
        UIManager.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    jTreeDemo.setCellRenderer(new DemoCellRenderer());
                }
            }
        });

        jTreeDemo.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        for (int i = 0; i < jTreeDemo.getRowCount(); i++)
            jTreeDemo.expandRow(i);
        jTreeDemo.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    setActiveDemo((((DemoTreeNode) e.getNewLeadSelectionPath().getLastPathComponent()).getConstraint()));
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        jTreeDemo.addTreeWillExpandListener(new TreeWillExpandListener() {
            public void treeWillExpand(TreeExpansionEvent event) {
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event);
            }
        });

        JPanel jPanelTree = new JPanel(new GridBagLayout());

        Util.constrain(jPanelTree, new JScrollPane(jTreeDemo, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                8, 0, 1, 2);

        jPanelTree.setPreferredSize(new Dimension(jPanelTree.getPreferredSize().width + 5, jPanelTree.getPreferredSize().height));
        jPanelTree.setMinimumSize(jPanelTree.getPreferredSize());
        return jPanelTree;
    }

    private JPanel getPanelDemo() {
        jPanelDemo = new JPanel(new CardLayout());

        Enumeration constraintKeys = constraint2demoble.keys();
        while (constraintKeys.hasMoreElements()) {
            String constraint = (String) constraintKeys.nextElement();
            Demoable demoable = (Demoable) constraint2demoble.get(constraint);
            JPanel demoPanel = demoable.getDemoPanel();
            if (demoPanel != null)
                jPanelDemo.add(demoPanel, constraint);
        }
        JPanel jPanelTmp = new JPanel(new GridBagLayout());
        Util.constrain(jPanelTmp, jPanelDemo,
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                0, 0, 0, 0);

        return jPanelTmp;
    }

    private JPanel getPanelDemoEx() {
        jPanelDemoEx = new JPanel(new GridBagLayout());
        jPanelDemoOption = new JPanel(new CardLayout() {
            public Dimension preferredLayoutSize(Container parent) {
                synchronized (parent.getTreeLock()) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h = 0;

                    for (int i = 0; i < ncomponents; i++) {
                        Component comp = parent.getComponent(i);
                        Dimension d = comp.getPreferredSize();
                        if (comp.isVisible()) {
                            w = d.width;
                            h = d.height;
                        }
                    }
                    return new Dimension(insets.left + insets.right + w + getHgap() * 2,
                            insets.top + insets.bottom + h + getVgap() * 2);
                }
            }
        });
        jPanelDemoDescription = new JPanel(new CardLayout() {
            public Dimension preferredLayoutSize(Container parent) {
//                return super.preferredLayoutSize(parent);
                synchronized (parent.getTreeLock()) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h = 0;

                    for (int i = 0; i < ncomponents; i++) {
                        Component comp = parent.getComponent(i);
                        Dimension d = comp.getPreferredSize();
                        if (comp.isVisible()) {
                            w = d.width;
                            h = d.height;
                        }
                    }
                    return new Dimension(insets.left + insets.right + w + getHgap() * 2,
                            insets.top + insets.bottom + h + getVgap() * 2);
                }
            }
        });
        Enumeration constraintKeys = constraint2demoble.keys();
        while (constraintKeys.hasMoreElements()) {
            String constraint = (String) constraintKeys.nextElement();
            Demoable demoable = (Demoable) constraint2demoble.get(constraint);
            JPanel optionPanel = demoable.getOptionPanel();
            if (optionPanel != null)
                jPanelDemoOption.add(optionPanel, constraint);
            JPanel descriptionPanel = demoable.getDescriptionPanel();
            if (descriptionPanel != null)
                jPanelDemoDescription.add(descriptionPanel, constraint);
        }

        jAnimatePanel = new JAnimatePanel();
        jAnimatePanel.setDelay(5);
        jAnimatePanel.setStep(16);
        jAnimatePanel.setTabSpacing(5);
        jAnimatePanel.setDefaultPaintMode(JAnimatePanel.MODE_ANIMATE);
        jAnimatePanel.setBorder(BorderFactory.createEmptyBorder());

        jPanelDemoOption.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor")));
        jPanelDemoDescription.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor")));

        jAnimateTabOptions = new JAnimateTab("Options", null, jPanelDemoOption);
        jAnimateTabOptions.setSelected(true);
        jAnimatePanel.addTab(jAnimateTabOptions);

        jAnimateTabDescriptions = new JAnimateTab("Description", null, jPanelDemoDescription);
        jAnimateTabDescriptions.setSelected(true);
        jAnimatePanel.addTab(jAnimateTabDescriptions);

        jAnimatePanel.setPreferredSize(new Dimension(200, jAnimatePanel.getPreferredSize().height));

        Util.constrain(jPanelDemoEx, jAnimatePanel,
                0, 0, 1, 1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0, 1.0,
                5, 5, 5, 5);

        return jPanelDemoEx;
    }

    public static void main(String[] args) {
        try {
            Demo demoInstance = new Demo(demoInputStream);
            demoInstance.showSplash(3000);
            demoInstance.init();
            demoInstance.pack();
            Util.centerOnScreen(demoInstance);
            demoInstance.jSliderPanelContainer.getLeftSlider().showSliderPanel(JSliderPanel.MODE_DEFAULT);
            demoInstance.show();
            demoInstance.jSliderPanelContainer.getRightSlider().setSliderWidth(220);
            for (int i = 0; i < demoInstance.jAnimatePanel.getTabCount(); i++)
                demoInstance.jAnimatePanel.getTab(i).setSelected(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSliderPanelContainer getSliderPanelContainer() {
        return jSliderPanelContainer;
    }

    public JAnimatePanel getAnimatePanel() {
        return jAnimatePanel;
    }

    private void setActiveDemo(String constraint) {        
        if (currentConstraint != null && currentConstraint.equals(constraint))
            return;

        if (currentConstraint != null)
            ((Demoable) constraint2demoble.get(currentConstraint)).demoWillBecomeInVisible();
        if (constraint != null)
            ((Demoable) constraint2demoble.get(constraint)).demoWillBecomeVisible();

        ((CardLayout) jPanelDemo.getLayout()).show(jPanelDemo, constraint);


        JPanel optionPanel = ((Demoable) constraint2demoble.get(constraint)).getOptionPanel();
        JPanel descPanel = ((Demoable) constraint2demoble.get(constraint)).getDescriptionPanel();
        if (optionPanel == null && descPanel == null)
            setOptionsControlsVisible(false);
        else
            setOptionsControlsVisible(true);


        if (optionPanel != null) {
            jAnimatePanel.addTab(0, jAnimateTabOptions);
            jPanelDemoOption.setVisible(true);
            ((CardLayout) jPanelDemoOption.getLayout()).show(jPanelDemoOption, constraint);
        } else {
            jAnimatePanel.removeTab(jAnimateTabOptions);
            jPanelDemoOption.setVisible(false);
        }
        if (descPanel != null) {
            jAnimatePanel.addTab(jAnimateTabDescriptions);
            jPanelDemoDescription.setVisible(true);
            ((CardLayout) jPanelDemoDescription.getLayout()).show(jPanelDemoDescription, constraint);
        } else {
            jAnimatePanel.removeTab(jAnimateTabDescriptions);
            jPanelDemoDescription.setVisible(false);
        }

        if (currentConstraint != null)
            ((Demoable) constraint2demoble.get(currentConstraint)).demoBecomeInVisible();
        if (constraint != null)
            ((Demoable) constraint2demoble.get(constraint)).demoBecomeVisible();

        currentConstraint = constraint;

        jTreeDemo.setSelectionPath(new TreePath(((DemoTreeNode) constraint2treenode.get(constraint)).getPath()));
    }

    private void setOptionsControlsVisible(boolean visible) {
        if (visible)
            try {
                if (rightSliderVisible)
                    jSliderPanelContainer.getRightSlider().showSliderPanel();
            } catch (Exception e) {
            }
        else
            try {
                jSliderPanelContainer.getRightSlider().hideSliderPanel();
            } catch (Exception e) {
            }

        jPanelDemoEx.setVisible(visible);
        jPanelRightControl.setVisible(visible);
    }

    protected JMenuBar getMainMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenuFile = new JMenu("File");
        JMenuItem jMenuItemExit = new JMenuItem(new AbstractAction("Exit") {
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        jMenuFile.add(jMenuItemExit);
        jMenuBar.add(jMenuFile);


        JMenu jMenuHelp = new JMenu("Help");
        JMenuItem jMenuItemAbout = new JMenuItem(new AbstractAction("About") {
            public void actionPerformed(ActionEvent event) {
                showSplash(JSplashScreen.INFINITE);
            }
        });
        jMenuHelp.add(jMenuItemAbout);
        jMenuBar.add(jMenuHelp);

        return jMenuBar;
    }
}
