/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.outlookpanel.renderers.metalwood;

import com.smardec.asc.outlookpanel.JOutlookTabHeader;
import com.smardec.asc.outlookpanel.OutlookTabHeaderRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class MetalWoodOutlookTabHeaderRenderer
extends JButton
implements OutlookTabHeaderRenderer,
Serializable {
    private static final ImageIcon imageIconOn = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOn.gif"));
    private static final ImageIcon imageIconOut = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOut.gif"));
    private static final ImageIcon imageIconArrowUp = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/ArrowUp.gif"));
    private static final ImageIcon imageIconArrowDown = new ImageIcon(MetalWoodOutlookTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/outlookpanel/renderers/MetalWoodOutlookRenderer/ArrowDown.gif"));
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private boolean mouseOver;
    private boolean mousePressed;

    public MetalWoodOutlookTabHeaderRenderer() {
        this.setOpaque(true);
    }

    public Component getOutlookTabHeaderRendererComponent(JOutlookTabHeader jOutlookTabHeader, boolean mouseOver, boolean mousePressed) {
        this.mouseOver = mouseOver;
        this.mousePressed = mousePressed;
        this.setFont(jOutlookTabHeader.getFont());
        this.setText(jOutlookTabHeader.getText());
        this.setSize(jOutlookTabHeader.getSize());
        try {
            int s_index = jOutlookTabHeader.getOutlookTab().getOutlookPanel().getSelectedTabIndex();
            int index = jOutlookTabHeader.getOutlookTab().getOutlookPanel().getTabIndex(jOutlookTabHeader.getOutlookTab());
            if (index != -1 && s_index != -1) {
                if (index <= s_index) {
                    this.setIcon(imageIconArrowDown);
                } else {
                    this.setIcon(imageIconArrowUp);
                }
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return this;
    }

    public void paint(Graphics g2) {
        if (this.mouseOver) {
            g2.drawImage(imageIconOn.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g2.drawImage(imageIconOut.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        g2.setFont(this.getFont());
        MetalWoodOutlookTabHeaderRenderer.viewRect.x = 0;
        MetalWoodOutlookTabHeaderRenderer.viewRect.y = 0;
        MetalWoodOutlookTabHeaderRenderer.viewRect.width = this.getWidth() - MetalWoodOutlookTabHeaderRenderer.viewRect.x;
        MetalWoodOutlookTabHeaderRenderer.viewRect.height = this.getHeight() - MetalWoodOutlookTabHeaderRenderer.viewRect.y;
        MetalWoodOutlookTabHeaderRenderer.textRect.height = 0;
        MetalWoodOutlookTabHeaderRenderer.textRect.width = 0;
        MetalWoodOutlookTabHeaderRenderer.textRect.y = 0;
        MetalWoodOutlookTabHeaderRenderer.textRect.x = 0;
        MetalWoodOutlookTabHeaderRenderer.iconRect.height = 0;
        MetalWoodOutlookTabHeaderRenderer.iconRect.width = 0;
        MetalWoodOutlookTabHeaderRenderer.iconRect.y = 0;
        MetalWoodOutlookTabHeaderRenderer.iconRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(this, g2.getFontMetrics(), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getText() == null ? 0 : 4);
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, g2, MetalWoodOutlookTabHeaderRenderer.iconRect.x, MetalWoodOutlookTabHeaderRenderer.iconRect.y);
        }
        this.paintText(g2, this, textRect, text);
    }

    protected void paintText(Graphics g2, JButton jButton, Rectangle textRect, String text) {
        JButton b2 = jButton;
        ButtonModel model = b2.getModel();
        FontMetrics fm = g2.getFontMetrics();
        int mnemonicIndex = -1;
        if (model.isEnabled()) {
            g2.setColor(b2.getForeground());
            this.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g2.setColor(b2.getBackground().brighter());
            this.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g2.setColor(b2.getBackground().darker());
            this.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected void drawStringUnderlineCharAt(Graphics g2, String text, int underlinedIndex, int x2, int y2) {
        g2.drawString(text, x2, y2);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g2.getFontMetrics();
            int underlineRectX = x2 + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y2;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g2.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }
}

