/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.demos;

import com.smardec.asc.table.FilteredTableModel;
import com.smardec.asc.table.RowFilter;
import com.smardec.asc.table.SortedTableHeaderMouseListener;
import com.smardec.asc.table.SortedTableHeaderRenderer;
import com.smardec.asc.table.SortedTableModel;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SortedFilteredTableDemo
extends DemoableAdapter {
    public static final String CONSTRAINT_TABLE = "Table";
    public static final String CAPTION_TABLE = "Sorted and filtered table";
    public static final String INTRO_TABLE = "<html><p align=left color=black>SortedTableModel - TableModel with sorting and multisorting support. FilteredTableModel - TableModel with filtering support. SortedTableModel and FilteredTableModel can be combined to create sorted and filtered table.</p><p align=left color=black>To enable multisorting support just hold CTRL key and click on several table headers. The column header will show an icon than represents column sort order (ascending/descending) and column sort rank.</p></html>";
    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;
    private FilteredTableModel filteredTableModel;

    public String getID() {
        return CONSTRAINT_TABLE;
    }

    public String getCaption() {
        return CAPTION_TABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return 2;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);
        int n = 26;
        Object[][] objects = new Object[26][4];
        char c2 = 'A';
        long time = System.currentTimeMillis();
        for (int i = 0; i < 26; ++i) {
            char c3 = c2;
            c2 = (char)(c2 + 1);
            objects[i][0] = new Character(c3);
            objects[i][1] = new Date(time - (long)(86400000 * (i - 10)));
            int temp = (i + 1) * (i % 2 == 0 ? -1 : 1) / 2;
            if (temp > 0) {
                temp = 14 - temp;
            }
            objects[i][2] = new Integer(temp);
            class ComparableBoolean
            implements Comparable {
                Boolean bool;

                public ComparableBoolean(boolean value) {
                    this.bool = new Boolean(value);
                }

                public ComparableBoolean(String s) {
                    this.bool = new Boolean(s);
                }

                public int compareTo(Object o2) {
                    return -this.bool.toString().compareTo(o2.toString());
                }

                public String toString() {
                    return this.bool.toString();
                }
            }
            objects[i][3] = new ComparableBoolean(i % 2 == 0);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objects, new Object[]{"String", "Date", "Number", "Boolean"}){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        SortedTableModel sortedTableModel = new SortedTableModel(defaultTableModel);
        this.filteredTableModel = new FilteredTableModel(sortedTableModel);
        JTable jTable = new JTable(this.filteredTableModel);
        jTable.getTableHeader().setReorderingAllowed(true);
        jTable.getTableHeader().addMouseListener(new SortedTableHeaderMouseListener(jTable, sortedTableModel));
        jTable.getTableHeader().setDefaultRenderer(new SortedTableHeaderRenderer(jTable, sortedTableModel));
        Util.constrain(jPanelTreeTable, new JScrollPane(jTable), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (this.jPanelOptions != null) {
            return this.jPanelOptions;
        }
        final RowFilter rowFilter = new RowFilter(){

            public boolean exclude(int row, TableModel tableModel) {
                return ((Number)tableModel.getValueAt(row, 2)).intValue() < 0;
            }
        };
        final JCheckBox jCheckBoxEnableFilter = new JCheckBox("Filter rows with negative values");
        jCheckBoxEnableFilter.setSelected(false);
        jCheckBoxEnableFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (jCheckBoxEnableFilter.isSelected()) {
                    SortedFilteredTableDemo.this.filteredTableModel.setRowFilter(rowFilter);
                } else {
                    SortedFilteredTableDemo.this.filteredTableModel.setRowFilter(null);
                }
            }
        });
        this.jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelOptions, jCheckBoxEnableFilter, 0, 1, 1, 1, 2, 18, 1.0, 0.0, 5, 1, 0, 5);
        return this.jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (this.jPanelDesc != null) {
            return this.jPanelDesc;
        }
        this.jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelDesc, new JLabel(INTRO_TABLE), 0, 1, 1, 1, 2, 18, 1.0, 1.0, 5, 5, 5, 5);
        Util.constrain(this.jPanelDesc, Box.createGlue(), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelDesc;
    }
}

