/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.demos;

import com.smardec.asc.quick.JQuickList;
import com.smardec.asc.quick.JQuickTable;
import com.smardec.asc.quick.JQuickTextArea;
import com.smardec.asc.quick.JQuickTree;
import com.smardec.asc.tree.WideTreeCellEditor;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuickSearchDemo
extends DemoableAdapter {
    public static final String CONSTRAINT_QUICK_SEARCH = "QuickSearch";
    public static final String CAPTION_QUICK_SEARCH = "Quick search";
    public static final String INTRO_QUICK_SEARCH = "<html><p align=left color=black>JQuickTree, JQuickTable, JQuickList and JQuickTextArea are Swing components with quick search capabilities. Start typing when the component has focus to use the quick search or select 'Invoke search on keystroke' and invoke quick search on keystroke. To use search mask ('*' and '?') select 'Search on mask'. While quick search is active you can select next/previuos matched element using up/down arrow keys, Ctrl+A selects all matching elements. JQuickTree also demostrates the usage of WideTreeCellEditor - an editor that has tree object's width.</p></html>";
    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;
    private JTabbedPane jTabbedPaneQuickSearch;
    private ChangeListener changeListener;
    private JQuickTree jQuickTree;
    private JQuickList jQuickList;
    private JQuickTable jQuickTable;
    private JQuickTextArea jQuickTextArea;

    public String getID() {
        return CONSTRAINT_QUICK_SEARCH;
    }

    public String getCaption() {
        return CAPTION_QUICK_SEARCH;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return 0;
    }

    public JPanel getDemoPanel() {
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                try {
                    JScrollPane jScrollPane = (JScrollPane)QuickSearchDemo.this.jTabbedPaneQuickSearch.getComponentAt(QuickSearchDemo.this.jTabbedPaneQuickSearch.getModel().getSelectedIndex());
                    jScrollPane.getViewport().getView().requestFocus();
                }
                catch (Exception exception) {
                    try {
                        JScrollPane jScrollPane = (JScrollPane)((Container)QuickSearchDemo.this.jTabbedPaneQuickSearch.getComponentAt(QuickSearchDemo.this.jTabbedPaneQuickSearch.getModel().getSelectedIndex())).getComponent(0);
                        jScrollPane.getViewport().getView().requestFocus();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        };
        this.jQuickTree = new JQuickTree();
        this.jQuickTree.setEditable(true);
        this.jQuickTree.setCellEditor(new WideTreeCellEditor(this.jQuickTree));
        for (int i = 0; i < this.jQuickTree.getRowCount(); ++i) {
            this.jQuickTree.expandRow(i);
        }
        this.jQuickList = new JQuickList(new String[]{"blue", "violet", "red", "yellow", "basketball", "soccer", "football", "hockey", "hot dogs", "pizza", "ravioli", "bananas"});
        this.jQuickTable = new JQuickTable(new String[][]{{"blue", "ravioli", "pizza"}, {"violet", "bananas", "ravioli"}, {"red", "pizza", "bananas"}, {"yellow", "hot dogs", "football"}, {"basketball", "hockey", "soccer"}, {"soccer", "football", "hot dogs"}, {"football", "soccer", "hockey"}, {"hockey", "basketball", "yellow"}, {"hot dogs", "yellow", "basketball"}, {"pizza", "red", "blue"}, {"ravioli", "blue", "violet"}, {"bananas", "violet", "red"}}, new String[]{"Column 1", "Column 2", "Column 3"});
        JPanel jPanelQuickTable = new JPanel(new BorderLayout());
        jPanelQuickTable.add((Component)new JScrollPane(this.jQuickTable), "Center");
        final JCheckBox jCheckBoxSearchEntireTable = new JCheckBox("Search in selected column only");
        jCheckBoxSearchEntireTable.setSelected(!this.jQuickTable.isSearchEntireTable());
        jCheckBoxSearchEntireTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                QuickSearchDemo.this.jQuickTable.setSearchEntireTable(!jCheckBoxSearchEntireTable.isSelected());
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        jPanelQuickTable.add((Component)jCheckBoxSearchEntireTable, "South");
        this.jQuickTextArea = new JQuickTextArea("blue\nviolet\nred\nyellow\nbasketball\nsoccer\nfootball\nhockey\nhot dogs\npizza\nravioli\nbananas\n");
        this.jTabbedPaneQuickSearch = new JTabbedPane(1);
        this.jTabbedPaneQuickSearch.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e2) {
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        this.jTabbedPaneQuickSearch.addChangeListener(this.changeListener);
        this.jTabbedPaneQuickSearch.addTab("JQuickTree", new JScrollPane(this.jQuickTree));
        this.jTabbedPaneQuickSearch.addTab("JQuickList", new JScrollPane(this.jQuickList));
        this.jTabbedPaneQuickSearch.addTab("JQuickTable", jPanelQuickTable);
        this.jTabbedPaneQuickSearch.addTab("JQuickTextArea", new JScrollPane(this.jQuickTextArea));
        JPanel jPanelQuickSearch = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_QUICK_SEARCH);
        titledBorder.setTitleColor(Color.black);
        jPanelQuickSearch.setBorder(titledBorder);
        Util.constrain(jPanelQuickSearch, this.jTabbedPaneQuickSearch, 0, 1, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        return jPanelQuickSearch;
    }

    public JPanel getOptionPanel() {
        if (this.jPanelOptions != null) {
            return this.jPanelOptions;
        }
        final JCheckBox jCheckBoxStrict = new JCheckBox("Strict mode");
        jCheckBoxStrict.setToolTipText("Strict mode");
        jCheckBoxStrict.setSelected(this.jQuickTree.getQuickSearch().isStrict());
        jCheckBoxStrict.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                QuickSearchDemo.this.jQuickTree.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                QuickSearchDemo.this.jQuickList.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                QuickSearchDemo.this.jQuickTable.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                QuickSearchDemo.this.jQuickTextArea.getQuickSearch().setStrict(jCheckBoxStrict.isSelected());
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxPrefereSelection = new JCheckBox("Prefere selection");
        jCheckBoxPrefereSelection.setToolTipText("Prefere selection");
        jCheckBoxPrefereSelection.setSelected(this.jQuickTree.getQuickSearch().isPrefereSelection());
        jCheckBoxPrefereSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                QuickSearchDemo.this.jQuickTree.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                QuickSearchDemo.this.jQuickList.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                QuickSearchDemo.this.jQuickTable.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                QuickSearchDemo.this.jQuickTextArea.getQuickSearch().setPrefereSelection(jCheckBoxPrefereSelection.isSelected());
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxSearchOnlyOnKeystroke = new JCheckBox("Invoke search on keystroke (Ctrl+F)");
        jCheckBoxSearchOnlyOnKeystroke.setToolTipText("Invoke search on keystroke (Ctrl+F)");
        jCheckBoxSearchOnlyOnKeystroke.setSelected(this.jQuickTree.getQuickSearch().getKeyStroke() != null);
        jCheckBoxSearchOnlyOnKeystroke.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                KeyStroke keyStroke = jCheckBoxSearchOnlyOnKeystroke.isSelected() ? KeyStroke.getKeyStroke("ctrl F") : null;
                QuickSearchDemo.this.jQuickTree.getQuickSearch().setKeyStroke(keyStroke);
                QuickSearchDemo.this.jQuickList.getQuickSearch().setKeyStroke(keyStroke);
                QuickSearchDemo.this.jQuickTable.getQuickSearch().setKeyStroke(keyStroke);
                QuickSearchDemo.this.jQuickTextArea.getQuickSearch().setKeyStroke(keyStroke);
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        final JCheckBox jCheckBoxUseMask = new JCheckBox("Search on mask ('*' and '?' can be used, not applicable to JQuickTextArea)");
        jCheckBoxUseMask.setToolTipText("Search on mask ('*' and '?' can be used, not applicable to JQuickTextArea)");
        jCheckBoxUseMask.setSelected(this.jQuickTree.getQuickSearch().isMaskSearch());
        jCheckBoxUseMask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                QuickSearchDemo.this.jQuickTree.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                QuickSearchDemo.this.jQuickList.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                QuickSearchDemo.this.jQuickTable.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                QuickSearchDemo.this.jQuickTextArea.getQuickSearch().setMaskSearch(jCheckBoxUseMask.isSelected());
                QuickSearchDemo.this.changeListener.stateChanged(null);
            }
        });
        this.jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelOptions, jCheckBoxStrict, 0, 2, 1, 1, 2, 18, 1.0, 0.0, 5, 1, 0, 5);
        Util.constrain(this.jPanelOptions, jCheckBoxPrefereSelection, 0, 3, 1, 1, 2, 18, 1.0, 0.0, 0, 1, 0, 5);
        Util.constrain(this.jPanelOptions, jCheckBoxSearchOnlyOnKeystroke, 0, 4, 1, 1, 2, 18, 1.0, 0.0, 0, 1, 0, 5);
        Util.constrain(this.jPanelOptions, jCheckBoxUseMask, 0, 5, 1, 1, 2, 18, 1.0, 0.0, 0, 1, 0, 5);
        return this.jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (this.jPanelDesc != null) {
            return this.jPanelDesc;
        }
        this.jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelDesc, new JLabel(INTRO_QUICK_SEARCH), 0, 1, 1, 1, 2, 18, 1.0, 1.0, 5, 5, 5, 5);
        Util.constrain(this.jPanelDesc, Box.createGlue(), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelDesc;
    }

    public void demoBecomeVisible() {
        this.jTabbedPaneQuickSearch.requestFocus();
    }
}

