/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.demos;

import com.smardec.asc.gradient.QuickGradientPaint;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class QuickGradientDemo
extends DemoableAdapter {
    public static final String CONSTRAINT_GRADIENT = "Gradient";
    public static final String CAPTION_GRADIENT = "QuickGradientPaint";
    public static final String INTRO_GRADIENT = "<html><p align=left color=black>QuickGradientPaint - optimized Paint for gradients. Useful for creating modern and fast user interfaces.</p></html>";
    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;

    public String getID() {
        return CONSTRAINT_GRADIENT;
    }

    public String getCaption() {
        return CAPTION_GRADIENT;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return 0;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelGradient = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_GRADIENT);
        titledBorder.setTitleColor(Color.black);
        jPanelGradient.setBorder(titledBorder);
        final JLabel jLabelControl = new JLabel();
        final JLabel jLabelTimeForSmart = new JLabel("Time of 100 runs: <unknown>");
        jLabelTimeForSmart.setForeground(Color.black);
        final JLabel jLabelTimeForStandard = new JLabel("Time of 100 runs: <unknown>");
        jLabelTimeForStandard.setForeground(Color.black);
        final JPanel jPanelSmartGradient = new JPanel(){

            protected void paintComponent(Graphics g2) {
                ((Graphics2D)g2).setPaint(new QuickGradientPaint(Color.gray, Color.lightGray, false));
                if ("smart".equals(jLabelControl.getText())) {
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 100; ++i) {
                        ((Graphics2D)g2).fill(new Rectangle(this.getSize()));
                    }
                    long time = System.currentTimeMillis() - start;
                    jLabelTimeForSmart.setText("Time of 100 runs: " + time + " milliseconds");
                    jLabelControl.setText("");
                } else {
                    ((Graphics2D)g2).fill(new Rectangle(this.getSize()));
                }
            }
        };
        jPanelSmartGradient.setBorder(BorderFactory.createLineBorder(Color.black));
        final JPanel jPanelStandardGradient = new JPanel(){

            protected void paintComponent(Graphics g2) {
                ((Graphics2D)g2).setPaint(new GradientPaint(0.0f, 0.0f, Color.gray, this.getWidth(), this.getHeight(), Color.lightGray));
                if ("standard".equals(jLabelControl.getText())) {
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 100; ++i) {
                        ((Graphics2D)g2).fill(new Rectangle(this.getSize()));
                    }
                    long time = System.currentTimeMillis() - start;
                    jLabelTimeForStandard.setText("Time of 100 runs: " + time + " milliseconds");
                    jLabelControl.setText("");
                } else {
                    ((Graphics2D)g2).fill(new Rectangle(this.getSize()));
                }
            }
        };
        jPanelStandardGradient.setBorder(BorderFactory.createLineBorder(Color.black));
        JButton jButtonMeasureSmart = new JButton("Measure");
        jButtonMeasureSmart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                jLabelControl.setText("smart");
                jPanelSmartGradient.repaint();
            }
        });
        JButton jButtonMeasureStandard = new JButton("Measure");
        jButtonMeasureStandard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                jLabelControl.setText("standard");
                jPanelStandardGradient.repaint();
            }
        });
        JLabel jLabel1 = new JLabel("Quick gradient:");
        jLabel1.setForeground(Color.black);
        Util.constrain(jPanelGradient, jLabel1, 0, 1, 2, 1, 2, 18, 1.0, 0.0, 0, 5, 0, 5);
        Util.constrain(jPanelGradient, jPanelSmartGradient, 0, 2, 2, 1, 1, 18, 1.0, 1.0, 0, 5, 0, 5);
        Util.constrain(jPanelGradient, jLabelTimeForSmart, 0, 3, 1, 1, 2, 18, 1.0, 0.0, 10, 5, 0, 0);
        Util.constrain(jPanelGradient, jButtonMeasureSmart, 1, 3, 1, 1, 0, 12, 1.0, 0.0, 5, 0, 0, 5);
        JLabel jLabel2 = new JLabel("Standard gradient:");
        jLabel2.setForeground(Color.black);
        Util.constrain(jPanelGradient, jLabel2, 0, 4, 2, 1, 2, 18, 1.0, 0.0, 0, 5, 0, 5);
        Util.constrain(jPanelGradient, jPanelStandardGradient, 0, 5, 2, 1, 1, 18, 1.0, 1.0, 0, 5, 0, 5);
        Util.constrain(jPanelGradient, jLabelTimeForStandard, 0, 6, 1, 1, 2, 18, 1.0, 0.0, 10, 5, 0, 0);
        Util.constrain(jPanelGradient, jButtonMeasureStandard, 1, 6, 1, 1, 0, 12, 1.0, 0.0, 5, 0, 5, 5);
        return jPanelGradient;
    }

    public JPanel getOptionPanel() {
        if (this.jPanelOptions != null) {
            return this.jPanelOptions;
        }
        return null;
    }

    public JPanel getDescriptionPanel() {
        if (this.jPanelDesc != null) {
            return this.jPanelDesc;
        }
        this.jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelDesc, new JLabel(INTRO_GRADIENT), 0, 1, 1, 1, 2, 18, 1.0, 1.0, 5, 5, 5, 5);
        Util.constrain(this.jPanelDesc, Box.createGlue(), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelDesc;
    }
}

