/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.demos;

import com.smardec.asc.treetable.DefaultTreeTableModel;
import com.smardec.asc.treetable.JTreeTable;
import com.smardec.asc.treetable.TreeTableNode;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class JTreeTableDemo
extends DemoableAdapter {
    public static final String CONSTRAINT_TREETABLE = "TreeTable";
    public static final String CAPTION_TREETABLE = "JTreeTable";
    public static final String INTRO_TREETABLE = "<html><p align=left color=black>JTreeTable - Swing component that combines JTable and JTree. It extends JTable and uses a JTree to display the cells in a particular column of the table.</p></html>";
    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;
    private JTreeTable jTreeTable;

    public String getID() {
        return CONSTRAINT_TREETABLE;
    }

    public String getCaption() {
        return CAPTION_TREETABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return 2;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TREETABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);
        TreeTableNode root = new TreeTableNode(new Object[]{"Sample JTreeTable", "", ""});
        TreeTableNode level1Node = null;
        TreeTableNode level2Node = null;
        for (int i = 1; i <= 150; ++i) {
            TreeTableNode node = new TreeTableNode(new Object[]{"Name " + i, "Value " + i, "Description " + i});
            if (i % 7 == 1) {
                root.add(node);
                level1Node = node;
                continue;
            }
            if (i % 7 == 2 || i % 7 == 5) {
                level1Node.add(node);
                level2Node = node;
                continue;
            }
            level2Node.add(node);
        }
        this.jTreeTable = new JTreeTable(new DefaultTreeTableModel(root));
        this.jTreeTable.getTree().setRootVisible(true);
        Util.constrain(jPanelTreeTable, new JScrollPane(this.jTreeTable), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (this.jPanelOptions != null) {
            return this.jPanelOptions;
        }
        final JCheckBox jCheckBoxWideSelectionBackground = new JCheckBox("Use wide selection background");
        jCheckBoxWideSelectionBackground.setSelected(this.jTreeTable.isWideSelectionBackground());
        jCheckBoxWideSelectionBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JTreeTableDemo.this.jTreeTable.setWideSelectionBackground(jCheckBoxWideSelectionBackground.isSelected());
                JTreeTableDemo.this.jTreeTable.repaint();
            }
        });
        final JCheckBox jCheckBoxRootVisible = new JCheckBox("Is root visible");
        jCheckBoxRootVisible.setSelected(this.jTreeTable.getTree().isRootVisible());
        jCheckBoxRootVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JTreeTableDemo.this.jTreeTable.getTree().setRootVisible(jCheckBoxRootVisible.isSelected());
                ((AbstractTableModel)JTreeTableDemo.this.jTreeTable.getModel()).fireTableDataChanged();
                JTreeTableDemo.this.jTreeTable.repaint();
            }
        });
        this.jPanelOptions = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelOptions, jCheckBoxWideSelectionBackground, 0, 1, 1, 1, 2, 18, 1.0, 0.0, 5, 1, 0, 5);
        Util.constrain(this.jPanelOptions, jCheckBoxRootVisible, 0, 2, 1, 1, 2, 18, 1.0, 0.0, 0, 1, 0, 5);
        Util.constrain(this.jPanelOptions, Box.createGlue(), 0, 3, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (this.jPanelDesc != null) {
            return this.jPanelDesc;
        }
        this.jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelDesc, new JLabel(INTRO_TREETABLE), 0, 1, 1, 1, 2, 18, 1.0, 1.0, 5, 5, 5, 5);
        Util.constrain(this.jPanelDesc, Box.createGlue(), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelDesc;
    }
}

