/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.demos;

import com.smardec.asc.spantable.DefaultSpanTableModel;
import com.smardec.asc.spantable.JSpanTable;
import com.smardec.asc.table.renderers.DefaultImageCellRenderer;
import com.smardec.asc.table.renderers.DefaultTextCellRenderer;
import com.smardec.asc.table.wrappers.DefaultImageWrapper;
import com.smardec.asc.table.wrappers.DefaultTextWrapper;
import com.smardec.demo.asc.DemoableAdapter;
import com.smardec.demo.asc.Util;
import com.smardec.demo.asc.spantable.HtmlRenderer;
import com.smardec.demo.asc.spantable.HtmlTextWrapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class JSpanTableDemo
extends DemoableAdapter {
    public static final String CONSTRAINT_TREETABLE = "SpanTable";
    public static final String CAPTION_TREETABLE = "JSpanTable";
    public static final String INTRO_TREETABLE = "<html><p align=left color=black>JSpanTable - Swing component based on JTable that provides api to create table with cell span</p></html>";
    private JPanel jPanelOptions = null;
    private JPanel jPanelDesc = null;
    private JSpanTable jSpanTable;
    private static final ImageIcon imageIconF430 = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_430.jpg"));
    private static final ImageIcon imageIconF612 = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_612.jpg"));
    private static final ImageIcon imageIconFEnzo = new ImageIcon(JSpanTableDemo.class.getClassLoader().getResource("com/smardec/demo/asc/img/spantable/ferrari_enzo.jpg"));

    public String getID() {
        return CONSTRAINT_TREETABLE;
    }

    public String getCaption() {
        return CAPTION_TREETABLE;
    }

    public Vector getContentDescriptions() {
        return null;
    }

    public int getState() {
        return 1;
    }

    public JPanel getDemoPanel() {
        JPanel jPanelTreeTable = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(CAPTION_TREETABLE);
        titledBorder.setTitleColor(Color.black);
        jPanelTreeTable.setBorder(titledBorder);
        this.jSpanTable = this.initCarDemo();
        this.setHeaderHeight(this.jSpanTable);
        Util.constrain(jPanelTreeTable, new JScrollPane(this.jSpanTable), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        return jPanelTreeTable;
    }

    public JPanel getOptionPanel() {
        if (this.jPanelOptions != null) {
            return this.jPanelOptions;
        }
        return this.jPanelOptions;
    }

    public JPanel getDescriptionPanel() {
        if (this.jPanelDesc != null) {
            return this.jPanelDesc;
        }
        this.jPanelDesc = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelDesc, new JLabel(INTRO_TREETABLE), 0, 1, 1, 1, 2, 18, 1.0, 1.0, 5, 5, 5, 5);
        Util.constrain(this.jPanelDesc, Box.createGlue(), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return this.jPanelDesc;
    }

    private JSpanTable initCarDemo() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("img");
        columnNames.add("txt");
        columnNames.add("txt");
        JSpanTable jSpanTable = new JSpanTable(new DefaultSpanTableModel(this.getCarInfo(), false, columnNames));
        jSpanTable.setAutoResizeMode(3);
        JTableHeader tableHeader = jSpanTable.getTableHeader();
        Dimension dim = tableHeader.getPreferredSize();
        dim.height = 0;
        tableHeader.setMinimumSize(dim);
        tableHeader.setMaximumSize(dim);
        tableHeader.setPreferredSize(dim);
        tableHeader.setSize(dim);
        tableHeader.setVisible(false);
        TableColumn column = jSpanTable.getColumnModel().getColumn(0);
        column.setResizable(false);
        int w = 196;
        column.setPreferredWidth(w);
        column.setMaxWidth(w);
        column.setMinWidth(w);
        column = jSpanTable.getColumnModel().getColumn(1);
        column.setResizable(false);
        w = 100;
        column.setPreferredWidth(w);
        column.setMaxWidth(w);
        column.setMinWidth(w);
        this.createSpans(jSpanTable);
        jSpanTable.setDefaultCellRenderer(DefaultTextWrapper.class, new DefaultTextCellRenderer());
        jSpanTable.setDefaultCellRenderer(DefaultImageWrapper.class, new DefaultImageCellRenderer());
        jSpanTable.setDefaultCellRenderer(HtmlTextWrapper.class, new HtmlRenderer());
        return jSpanTable;
    }

    private Vector getCarInfo() {
        int i;
        Vector<List<Object>> v2 = new Vector<List<Object>>();
        Font font = UIManager.getFont("Table.font");
        Object[] data = new Object[]{new Object[]{new DefaultTextWrapper("Ferrari F430", Color.red, new Color(0, 100, 0), font.deriveFont(1, font.getSize() + 2), 0, 0), null, null}, new Object[]{new DefaultImageWrapper(imageIconF430, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(1)), "2005 - present"}, new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(1)), "Sports car"}, new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(1)), "2-seat Berlinetta; 2-seat Spider"}, new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(1)), "4.3 L V8"}, new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(1)), "360.4 kW (483 hp) at 8500 rpm"}, new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(1)), "465 N\u00b7m (343 ft\u00b7lbf) at 5250 rpm"}, new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(1)), "3.5 second"}, new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(1)), "$170,045"}, new Object[]{new HtmlTextWrapper("The Ferrari F430 is a sports car automobile, the replacement for the Ferrari 360. It debuted at the September, 2004 Paris Motor Show. European left-hand drive sales began in November, 2004, but right-hand drive sales did not start until Spring 2005, and the United States did not get the F430 until the Summer of 2005."), null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}};
        for (i = 0; i < data.length; ++i) {
            v2.add(Arrays.asList((Object[])data[i]));
        }
        data = new Object[]{new Object[]{new DefaultTextWrapper("Ferrari 612 Scaglietti", Color.red, new Color(0, 100, 0), font.deriveFont(1, font.getSize() + 2), 0, 0), null, null}, new Object[]{new DefaultImageWrapper(imageIconF612, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(1)), "2004 - present"}, new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(1)), "Gran Turismo"}, new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(1)), "front-engined 2+2 coupe"}, new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(1)), "5.7 L Tipo F133E V12"}, new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(1)), "397 kW (533 hp) at 7250 rpm"}, new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(1)), "588 N\u00b7m (434 ft\u00b7lbf) at 5250 rpm"}, new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(1)), "4.2 seconds"}, new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(1)), "$247,850"}, new Object[]{new HtmlTextWrapper("The Ferrari 612 Scaglietti is a Gran Turismo car produced by Ferrari since 2004. It is a large two door coupe with a 2+2 seating arrangement. The 612 Scaglietti was designed to replace the smaller Ferrari 456M."), null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}};
        for (i = 0; i < data.length; ++i) {
            v2.add(Arrays.asList((Object[])data[i]));
        }
        data = new Object[]{new Object[]{new DefaultTextWrapper("Ferrari 'Enzo Ferrari'", Color.red, new Color(0, 100, 0), font.deriveFont(1, font.getSize() + 2), 0, 0), null, null}, new Object[]{new DefaultImageWrapper(imageIconFEnzo, null, true, true), new DefaultTextWrapper(" Production:", font.deriveFont(1)), "2003 - 2004"}, new Object[]{null, new DefaultTextWrapper(" Class:", font.deriveFont(1)), "Supercar"}, new Object[]{null, new DefaultTextWrapper(" Body style:", font.deriveFont(1)), "coupe"}, new Object[]{null, new DefaultTextWrapper(" Engine:", font.deriveFont(1)), "6.0 L V12"}, new Object[]{null, new DefaultTextWrapper(" Power:", font.deriveFont(1)), "660 PS (651 hp/485 kW) at 7800 rpm"}, new Object[]{null, new DefaultTextWrapper(" Torque:", font.deriveFont(1)), "657 N\u00b7m (485 ft\u00b7lbf) at 5500 rpm"}, new Object[]{null, new DefaultTextWrapper(" 0-60 mph time:", font.deriveFont(1)), "3.3 seconds"}, new Object[]{null, new DefaultTextWrapper(" Base MSRP:", font.deriveFont(1)), "$643,330"}, new Object[]{new HtmlTextWrapper("The Enzo Ferrari is a 12-cylinder Ferrari supercar named after the company's founder, Enzo Ferrari. It was built in 2003 using Formula One technology, such as a carbon-fiber body, F1-style sequential shift transmission, and carbon-ceramic brake discs. Also used are technologies not allowed in F1 such as active aerodynamics."), null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}, new Object[]{null, null, null}};
        for (i = 0; i < data.length; ++i) {
            v2.add(Arrays.asList((Object[])data[i]));
        }
        return v2;
    }

    private void createSpans(JSpanTable jSpanTable) {
        int captionRowIndex = 0;
        int imageRowIndex = 1;
        int descRowIndex = 9;
        int carRowCount = 14;
        for (int i = 0; i < jSpanTable.getRowCount(); ++i) {
            for (int j2 = 0; j2 < jSpanTable.getColumnCount(); ++j2) {
                if ((i - captionRowIndex) % carRowCount == 0 && j2 == 0) {
                    jSpanTable.createSpan(i, j2, 1, 3);
                    continue;
                }
                if ((i - imageRowIndex) % carRowCount == 0 && j2 == 0) {
                    jSpanTable.createSpan(i, j2, 8, 1);
                    continue;
                }
                if ((i - descRowIndex) % carRowCount != 0 || j2 != 0) continue;
                jSpanTable.createSpan(i, j2, 5, 3);
            }
        }
    }

    private void setHeaderHeight(JSpanTable jSpanTable) {
        int carRowCount = 14;
        for (int i = 0; i < jSpanTable.getRowCount(); i += carRowCount) {
            jSpanTable.setRowHeight(i, jSpanTable.getRowHeight(i) + 4);
        }
    }
}

