/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc.animatepanel.renderers.metalwood;

import com.smardec.asc.animatepanel.AnimateTabHeaderRenderer;
import com.smardec.asc.animatepanel.JAnimateTabHeader;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class MetalWoodAnimateTabHeaderRenderer
extends JButton
implements AnimateTabHeaderRenderer,
Serializable {
    private static final ImageIcon imageIconOn = new ImageIcon(MetalWoodAnimateTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/animatepanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOn.gif"));
    private static final ImageIcon imageIconOut = new ImageIcon(MetalWoodAnimateTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/animatepanel/renderers/MetalWoodOutlookRenderer/TabBG_MouseOut.gif"));
    private static final ImageIcon imageIconArrowUp = new ImageIcon(MetalWoodAnimateTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/animatepanel/renderers/MetalWoodOutlookRenderer/ArrowUp.gif"));
    private static final ImageIcon imageIconArrowDown = new ImageIcon(MetalWoodAnimateTabHeaderRenderer.class.getClassLoader().getResource("com/smardec/demo/asc/img/animatepanel/renderers/MetalWoodOutlookRenderer/ArrowDown.gif"));
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private boolean mouseOver;
    private boolean mousePressed;

    public MetalWoodAnimateTabHeaderRenderer() {
        this.setOpaque(true);
    }

    public Component getAnimateTabHeaderRendererComponent(JAnimateTabHeader jAnimateTabHeader, boolean mouseOver, boolean mousePressed) {
        this.mouseOver = mouseOver;
        this.mousePressed = mousePressed;
        this.setFont(jAnimateTabHeader.getFont());
        this.setText(jAnimateTabHeader.getText());
        this.setSize(jAnimateTabHeader.getSize());
        try {
            if (jAnimateTabHeader.getAnimateTab().isSelected()) {
                this.setIcon(imageIconArrowUp);
            } else {
                this.setIcon(imageIconArrowDown);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }

    public void paint(Graphics g) {
        if (this.mouseOver) {
            g.drawImage(imageIconOn.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g.drawImage(imageIconOut.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        g.setFont(this.getFont());
        MetalWoodAnimateTabHeaderRenderer.viewRect.x = 0;
        MetalWoodAnimateTabHeaderRenderer.viewRect.y = 0;
        MetalWoodAnimateTabHeaderRenderer.viewRect.width = this.getWidth() - MetalWoodAnimateTabHeaderRenderer.viewRect.x;
        MetalWoodAnimateTabHeaderRenderer.viewRect.height = this.getHeight() - MetalWoodAnimateTabHeaderRenderer.viewRect.y;
        MetalWoodAnimateTabHeaderRenderer.textRect.height = 0;
        MetalWoodAnimateTabHeaderRenderer.textRect.width = 0;
        MetalWoodAnimateTabHeaderRenderer.textRect.y = 0;
        MetalWoodAnimateTabHeaderRenderer.textRect.x = 0;
        MetalWoodAnimateTabHeaderRenderer.iconRect.height = 0;
        MetalWoodAnimateTabHeaderRenderer.iconRect.width = 0;
        MetalWoodAnimateTabHeaderRenderer.iconRect.y = 0;
        MetalWoodAnimateTabHeaderRenderer.iconRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getText() == null ? 0 : 4);
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, g, MetalWoodAnimateTabHeaderRenderer.iconRect.x, MetalWoodAnimateTabHeaderRenderer.iconRect.y);
        }
        this.paintText(g, this, textRect, text);
    }

    protected void paintText(Graphics g, JButton jButton, Rectangle textRect, String text) {
        JButton b = jButton;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = -1;
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            this.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(b.getBackground().brighter());
            this.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            this.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        g.drawString(text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }
}

