/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.demo.asc;

import com.smardec.asc.animatepanel.JAnimatePanel;
import com.smardec.asc.animatepanel.JAnimateTab;
import com.smardec.asc.rotate.JVerticalToggleButton;
import com.smardec.asc.sliderpanel.JSliderPanel;
import com.smardec.asc.sliderpanel.JSliderPanelContainer;
import com.smardec.asc.splashscreen.JSplashScreen;
import com.smardec.asc.statusbar.JMemoryIndicator;
import com.smardec.demo.asc.Demoable;
import com.smardec.demo.asc.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Demo
extends JFrame {
    private static InputStream demoInputStream = Demo.class.getClassLoader().getResourceAsStream("com/smardec/demo/asc/demos.xml");
    private final ImageIcon imageNew = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/new.gif"));
    private final ImageIcon imageUpdated = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/updated.gif"));
    private final ImageIcon imageSplash = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/splash.gif"));
    private final ImageIcon imageIcon16 = new ImageIcon(Demo.class.getClassLoader().getResource("com/smardec/demo/asc/img/demoframework/icon16.gif"));
    private Reader xmlReader = null;
    private JPanel jPanelDemo;
    private JPanel jPanelDemoEx;
    private JPanel jPanelRightControl;
    private JPanel jPanelDemoOption;
    private JPanel jPanelDemoDescription;
    boolean rightSliderVisible = true;
    private String currentConstraint;
    private JTree jTreeDemo;
    private Hashtable constraint2treenode;
    private Hashtable constraint2demoble;
    private static final String CONSTRAINT_ROOT = "root";
    private static final String CAPTION_ROOT = "root";
    private JSliderPanelContainer jSliderPanelContainer;
    private JAnimatePanel jAnimatePanel;
    private JAnimateTab jAnimateTabOptions;
    private JAnimateTab jAnimateTabDescriptions;

    public Demo(String xmlFileName) throws Exception {
        this.xmlReader = Demo.getXMLReader(xmlFileName);
        this.initLocalVars();
    }

    public Demo(InputStream inputStream) throws Exception {
        this.xmlReader = Demo.getXMLReader(inputStream);
        this.initLocalVars();
    }

    protected void initLocalVars() {
    }

    protected void init() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Advanced Swing Components Demo");
        if (this.imageIcon16 != null) {
            this.setIconImage(this.imageIcon16.getImage());
        }
        this.setJMenuBar(this.getMainMenu());
        JVerticalToggleButton jVerticalToggleButtonLeft = new JVerticalToggleButton("Demo structure", 2);
        JVerticalToggleButton jVerticalToggleButtonRight = new JVerticalToggleButton("Descriptions & Options", 4);
        jVerticalToggleButtonLeft.setSelected(true);
        jVerticalToggleButtonRight.setSelected(true);
        JPanel jPanelLeftControl = new JPanel(new GridBagLayout());
        Util.constrain(jPanelLeftControl, jVerticalToggleButtonLeft, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 9, 4, 5, 2);
        Util.constrain(jPanelLeftControl, Box.createGlue(), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.jPanelRightControl = new JPanel(new GridBagLayout());
        Util.constrain(this.jPanelRightControl, jVerticalToggleButtonRight, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 9, 2, 5, 4);
        Util.constrain(this.jPanelRightControl, Box.createGlue(), 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        final JPanel jPanelTree = this.getPanelTree(this.xmlReader);
        JPanel jPanelDemo = this.getPanelDemo();
        final JPanel jPanelDemoEx = this.getPanelDemoEx();
        this.jSliderPanelContainer = new JSliderPanelContainer();
        this.jSliderPanelContainer.addBaseComponent(jPanelDemo);
        this.jSliderPanelContainer.getLeftSlider().addSliderContent(jPanelTree);
        this.jSliderPanelContainer.getLeftSlider().setMenuBarVisible(false);
        this.jSliderPanelContainer.getLeftSlider().setDock(true);
        this.jSliderPanelContainer.getLeftSlider().setPin(true);
        this.jSliderPanelContainer.getRightSlider().addSliderContent(jPanelDemoEx);
        this.jSliderPanelContainer.getRightSlider().setMenuBarVisible(false);
        this.jSliderPanelContainer.getRightSlider().setDock(true);
        this.jSliderPanelContainer.getRightSlider().setPin(true);
        jVerticalToggleButtonLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSliderPanel jSliderPanelLeft = Demo.this.jSliderPanelContainer.getLeftSlider();
                if (!jSliderPanelLeft.isVisible()) {
                    try {
                        jSliderPanelLeft.setMenuBarVisible(false);
                        jSliderPanelLeft.setDock(true);
                        jSliderPanelLeft.setPin(true);
                        Demo.this.jSliderPanelContainer.showPanelLeft(jPanelTree, 2);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelLeft.isSliderHiding()) {
                            Demo.this.jSliderPanelContainer.hidePanelLeft(2);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        jVerticalToggleButtonRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSliderPanel jSliderPanelRight = Demo.this.jSliderPanelContainer.getRightSlider();
                if (!jSliderPanelRight.isVisible()) {
                    try {
                        jSliderPanelRight.setMenuBarVisible(false);
                        jSliderPanelRight.setDock(true);
                        jSliderPanelRight.setPin(true);
                        Demo.this.jSliderPanelContainer.showPanelRight(jPanelDemoEx, 2);
                        Demo.this.rightSliderVisible = true;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        if (!jSliderPanelRight.isSliderHiding()) {
                            Demo.this.jSliderPanelContainer.hidePanelRight(2);
                            Demo.this.rightSliderVisible = false;
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanelContainer = new JPanel(new GridBagLayout());
        Util.constrain(jPanelContainer, this.jSliderPanelContainer, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 2, 2, 5, 2);
        this.getContentPane().add((Component)jPanelContainer, "Center");
        this.getContentPane().add((Component)jPanelLeftControl, "West");
        this.getContentPane().add((Component)this.jPanelRightControl, "East");
        JMemoryIndicator jMemoryIndicator = new JMemoryIndicator(new Dimension(100, 20), 1000, null, BorderFactory.createLineBorder(Color.black));
        JPanel jPanelMemory = new JPanel(new FlowLayout(2));
        jPanelMemory.add(jMemoryIndicator);
        this.getContentPane().add((Component)jPanelMemory, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.width < 950 || screenSize.height < 600) {
            ((JComponent)this.getContentPane()).setPreferredSize(new Dimension(screenSize.width - 20, screenSize.height - 100));
        } else {
            ((JComponent)this.getContentPane()).setPreferredSize(new Dimension(950, 600));
        }
        this.setActiveDemo("About");
    }

    public void showSplash(int displayTime) {
        JSplashScreen splash = new JSplashScreen(this);
        splash.setImage(this.imageSplash);
        splash.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        splash.setCloseOnClick(true);
        splash.setMinimumDisplayTime(0);
        splash.setDisplayTime(displayTime);
        splash.setHyperlinkRectangle(new Rectangle(13, 226, 108, 12));
        splash.setUrl("http://www.smardec.com");
        splash.showSplash();
    }

    private DemoTreeNode addDemoTreeNode(String caption, String constraint, DemoTreeNode root) {
        DemoTreeNode tn = new DemoTreeNode(caption, constraint);
        this.constraint2treenode.put(constraint, tn);
        if (root != null) {
            root.add(tn);
        }
        return tn;
    }

    private static Reader getXMLReader(String name) throws Exception {
        return new BufferedReader(new FileReader(name));
    }

    private static Reader getXMLReader(InputStream inputStream) throws Exception {
        return new InputStreamReader(inputStream);
    }

    private Demoable loadDemo(Node nodeDemo, DemoTreeNode rootTreeNode) throws Exception, IllegalAccessException, InstantiationException {
        Class<?> demoClass;
        NamedNodeMap attributes = nodeDemo.getAttributes();
        if (attributes.getNamedItem("class") != null) {
            String demoClassName = attributes.getNamedItem("class").getNodeValue();
            try {
                demoClass = Class.forName(demoClassName);
            }
            catch (NoClassDefFoundError e2) {
                return null;
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        } else {
            throw new Exception("Failed creating demo. Required attribute 'class' is missing");
        }
        Demoable demoable = (Demoable)demoClass.newInstance();
        demoable.init(this);
        DemoTreeNode tn = this.addDemoTreeNode(demoable.getCaption(), demoable.getID(), rootTreeNode);
        NodeList nodeListItems = nodeDemo.getChildNodes();
        for (int i = 0; i < nodeListItems.getLength(); ++i) {
            Demoable demoableChild;
            if (!"demo".equalsIgnoreCase(nodeListItems.item(i).getNodeName()) || (demoableChild = this.loadDemo(nodeListItems.item(i), tn)) == null) continue;
            if (this.constraint2demoble.get(demoableChild.getID()) != null) {
                throw new Exception("Failed creating demo tree. Demo id must be unique. Id '" + demoableChild.getID() + "' is duplicated.");
            }
            this.constraint2demoble.put(demoableChild.getID(), demoableChild);
        }
        return demoable;
    }

    private JPanel getPanelTree(Reader reader) {
        this.constraint2treenode = new Hashtable();
        this.constraint2demoble = new Hashtable();
        DemoTreeNode rootTreeNode = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            Element root = document.getDocumentElement();
            rootTreeNode = this.addDemoTreeNode("root", "root", null);
            NodeList nodeListDemo = root.getChildNodes();
            for (int i = 0; i < nodeListDemo.getLength(); ++i) {
                if (!"demo".equalsIgnoreCase(nodeListDemo.item(i).getNodeName())) continue;
                Demoable demoable = this.loadDemo(nodeListDemo.item(i), rootTreeNode);
                if (this.constraint2demoble.get(demoable.getID()) != null) {
                    throw new Exception("Failed creating demo tree. Demo id must be unique. Id '" + demoable.getID() + "' is duplicated.");
                }
                this.constraint2demoble.put(demoable.getID(), demoable);
            }
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
        this.jTreeDemo = new JTree(new DefaultTreeModel(rootTreeNode));
        this.jTreeDemo.setEditable(false);
        this.jTreeDemo.setRootVisible(false);
        this.jTreeDemo.setCellRenderer(new DemoCellRenderer());
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    Demo.this.jTreeDemo.setCellRenderer(new DemoCellRenderer());
                }
            }
        });
        this.jTreeDemo.getSelectionModel().setSelectionMode(1);
        for (int i = 0; i < this.jTreeDemo.getRowCount(); ++i) {
            this.jTreeDemo.expandRow(i);
        }
        this.jTreeDemo.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e2) {
                try {
                    Demo.this.setActiveDemo(((DemoTreeNode)e2.getNewLeadSelectionPath().getLastPathComponent()).getConstraint());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.jTreeDemo.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) {
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event);
            }
        });
        JPanel jPanelTree = new JPanel(new GridBagLayout());
        Util.constrain(jPanelTree, new JScrollPane(this.jTreeDemo, 20, 30), 0, 0, 1, 1, 1, 18, 1.0, 1.0, 8, 0, 1, 2);
        jPanelTree.setPreferredSize(new Dimension(jPanelTree.getPreferredSize().width + 5, jPanelTree.getPreferredSize().height));
        jPanelTree.setMinimumSize(jPanelTree.getPreferredSize());
        return jPanelTree;
    }

    private JPanel getPanelDemo() {
        this.jPanelDemo = new JPanel(new CardLayout());
        Enumeration constraintKeys = this.constraint2demoble.keys();
        while (constraintKeys.hasMoreElements()) {
            String constraint = (String)constraintKeys.nextElement();
            Demoable demoable = (Demoable)this.constraint2demoble.get(constraint);
            JPanel demoPanel = demoable.getDemoPanel();
            if (demoPanel == null) continue;
            this.jPanelDemo.add((Component)demoPanel, constraint);
        }
        JPanel jPanelTmp = new JPanel(new GridBagLayout());
        Util.constrain(jPanelTmp, this.jPanelDemo, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return jPanelTmp;
    }

    private JPanel getPanelDemoEx() {
        this.jPanelDemoEx = new JPanel(new GridBagLayout());
        this.jPanelDemoOption = new JPanel(new CardLayout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h2 = 0;
                    for (int i = 0; i < ncomponents; ++i) {
                        Component comp = parent.getComponent(i);
                        Dimension d2 = comp.getPreferredSize();
                        if (!comp.isVisible()) continue;
                        w = d2.width;
                        h2 = d2.height;
                    }
                    return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h2 + this.getVgap() * 2);
                }
            }
        });
        this.jPanelDemoDescription = new JPanel(new CardLayout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int w = 0;
                    int h2 = 0;
                    for (int i = 0; i < ncomponents; ++i) {
                        Component comp = parent.getComponent(i);
                        Dimension d2 = comp.getPreferredSize();
                        if (!comp.isVisible()) continue;
                        w = d2.width;
                        h2 = d2.height;
                    }
                    return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h2 + this.getVgap() * 2);
                }
            }
        });
        Enumeration constraintKeys = this.constraint2demoble.keys();
        while (constraintKeys.hasMoreElements()) {
            JPanel descriptionPanel;
            String constraint = (String)constraintKeys.nextElement();
            Demoable demoable = (Demoable)this.constraint2demoble.get(constraint);
            JPanel optionPanel = demoable.getOptionPanel();
            if (optionPanel != null) {
                this.jPanelDemoOption.add((Component)optionPanel, constraint);
            }
            if ((descriptionPanel = demoable.getDescriptionPanel()) == null) continue;
            this.jPanelDemoDescription.add((Component)descriptionPanel, constraint);
        }
        this.jAnimatePanel = new JAnimatePanel();
        this.jAnimatePanel.setDelay(5);
        this.jAnimatePanel.setStep(16);
        this.jAnimatePanel.setTabSpacing(5);
        this.jAnimatePanel.setDefaultPaintMode(2);
        this.jAnimatePanel.setBorder(BorderFactory.createEmptyBorder());
        this.jPanelDemoOption.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelDemoDescription.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor")));
        this.jAnimateTabOptions = new JAnimateTab("Options", null, this.jPanelDemoOption);
        this.jAnimateTabOptions.setSelected(true);
        this.jAnimatePanel.addTab(this.jAnimateTabOptions);
        this.jAnimateTabDescriptions = new JAnimateTab("Description", null, this.jPanelDemoDescription);
        this.jAnimateTabDescriptions.setSelected(true);
        this.jAnimatePanel.addTab(this.jAnimateTabDescriptions);
        this.jAnimatePanel.setPreferredSize(new Dimension(200, this.jAnimatePanel.getPreferredSize().height));
        Util.constrain(this.jPanelDemoEx, this.jAnimatePanel, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 5, 5);
        return this.jPanelDemoEx;
    }

    public static void main(String[] args) {
        try {
            Demo demoInstance = new Demo(demoInputStream);
            demoInstance.showSplash(3000);
            demoInstance.init();
            demoInstance.pack();
            Util.centerOnScreen(demoInstance);
            demoInstance.jSliderPanelContainer.getLeftSlider().showSliderPanel(1);
            demoInstance.show();
            demoInstance.jSliderPanelContainer.getRightSlider().setSliderWidth(220);
            for (int i = 0; i < demoInstance.jAnimatePanel.getTabCount(); ++i) {
                demoInstance.jAnimatePanel.getTab(i).setSelected(true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JSliderPanelContainer getSliderPanelContainer() {
        return this.jSliderPanelContainer;
    }

    public JAnimatePanel getAnimatePanel() {
        return this.jAnimatePanel;
    }

    private void setActiveDemo(String constraint) {
        if (this.currentConstraint != null && this.currentConstraint.equals(constraint)) {
            return;
        }
        if (this.currentConstraint != null) {
            ((Demoable)this.constraint2demoble.get(this.currentConstraint)).demoWillBecomeInVisible();
        }
        if (constraint != null) {
            ((Demoable)this.constraint2demoble.get(constraint)).demoWillBecomeVisible();
        }
        ((CardLayout)this.jPanelDemo.getLayout()).show(this.jPanelDemo, constraint);
        JPanel optionPanel = ((Demoable)this.constraint2demoble.get(constraint)).getOptionPanel();
        JPanel descPanel = ((Demoable)this.constraint2demoble.get(constraint)).getDescriptionPanel();
        if (optionPanel == null && descPanel == null) {
            this.setOptionsControlsVisible(false);
        } else {
            this.setOptionsControlsVisible(true);
        }
        if (optionPanel != null) {
            this.jAnimatePanel.addTab(0, this.jAnimateTabOptions);
            this.jPanelDemoOption.setVisible(true);
            ((CardLayout)this.jPanelDemoOption.getLayout()).show(this.jPanelDemoOption, constraint);
        } else {
            this.jAnimatePanel.removeTab(this.jAnimateTabOptions);
            this.jPanelDemoOption.setVisible(false);
        }
        if (descPanel != null) {
            this.jAnimatePanel.addTab(this.jAnimateTabDescriptions);
            this.jPanelDemoDescription.setVisible(true);
            ((CardLayout)this.jPanelDemoDescription.getLayout()).show(this.jPanelDemoDescription, constraint);
        } else {
            this.jAnimatePanel.removeTab(this.jAnimateTabDescriptions);
            this.jPanelDemoDescription.setVisible(false);
        }
        if (this.currentConstraint != null) {
            ((Demoable)this.constraint2demoble.get(this.currentConstraint)).demoBecomeInVisible();
        }
        if (constraint != null) {
            ((Demoable)this.constraint2demoble.get(constraint)).demoBecomeVisible();
        }
        this.currentConstraint = constraint;
        this.jTreeDemo.setSelectionPath(new TreePath(((DemoTreeNode)this.constraint2treenode.get(constraint)).getPath()));
    }

    private void setOptionsControlsVisible(boolean visible) {
        if (visible) {
            try {
                if (this.rightSliderVisible) {
                    this.jSliderPanelContainer.getRightSlider().showSliderPanel();
                }
            }
            catch (Exception e2) {}
        } else {
            try {
                this.jSliderPanelContainer.getRightSlider().hideSliderPanel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jPanelDemoEx.setVisible(visible);
        this.jPanelRightControl.setVisible(visible);
    }

    protected JMenuBar getMainMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenuFile = new JMenu("File");
        JMenuItem jMenuItemExit = new JMenuItem(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        jMenuFile.add(jMenuItemExit);
        jMenuBar.add(jMenuFile);
        JMenu jMenuHelp = new JMenu("Help");
        JMenuItem jMenuItemAbout = new JMenuItem(new AbstractAction("About"){

            public void actionPerformed(ActionEvent event) {
                Demo.this.showSplash(-1);
            }
        });
        jMenuHelp.add(jMenuItemAbout);
        jMenuBar.add(jMenuHelp);
        return jMenuBar;
    }

    private class DemoCellRenderer
    extends DefaultTreeCellRenderer {
        public DemoCellRenderer() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JPanel jPanel = null;
            try {
                JLabel treeCellRendererComponent = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                JLabel iconLabel = new JLabel();
                iconLabel.setVerticalAlignment(0);
                treeCellRendererComponent.setVerticalAlignment(0);
                String constraint = ((DemoTreeNode)value).getConstraint();
                if (constraint.equals("root")) {
                    return treeCellRendererComponent;
                }
                Demoable demoable = (Demoable)Demo.this.constraint2demoble.get(constraint);
                if (demoable.getState() == 0) {
                    iconLabel.setIcon(null);
                } else if (demoable.getState() == 1) {
                    iconLabel.setIcon(Demo.this.imageNew);
                } else if (demoable.getState() == 2) {
                    iconLabel.setIcon(Demo.this.imageUpdated);
                }
                jPanel = new JPanel(new FlowLayout(0, 1, 1));
                jPanel.setOpaque(false);
                jPanel.add(treeCellRendererComponent);
                jPanel.add(iconLabel);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return jPanel;
        }
    }

    private class DemoTreeNode
    extends DefaultMutableTreeNode {
        private String constraint;

        public DemoTreeNode(Object userObject, String constraint) {
            super(userObject);
            this.constraint = constraint;
        }

        public String getConstraint() {
            return this.constraint;
        }
    }
}

